/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.DciSummaryTableColumn;

public class DciSummaryTable {
    public static final int MULTI_INSTANCE = 1;
    public static final int TABLE_DCI_SOURCE = 2;
    private int id;
    private UUID guid;
    private String menuPath;
    private String title;
    private int flags;
    private String nodeFilter;
    private List<DciSummaryTableColumn> columns;
    private String tableDciName;

    public DciSummaryTable(String menuPath, String title, boolean isTableSource) {
        this.id = 0;
        this.guid = UUID.randomUUID();
        this.menuPath = menuPath;
        this.title = title;
        this.flags = isTableSource ? 2 : 0;
        this.nodeFilter = "";
        this.columns = new ArrayList<DciSummaryTableColumn>();
        this.tableDciName = "";
    }

    public DciSummaryTable(String menuPath, String title) {
        this(menuPath, title, false);
    }

    public DciSummaryTable(NXCPMessage msg2) {
        this.id = msg2.getFieldAsInt32(444L);
        this.guid = msg2.getFieldAsUUID(222L);
        this.menuPath = msg2.getFieldAsString(445L);
        this.title = msg2.getFieldAsString(447L);
        this.flags = msg2.getFieldAsInt32(13L);
        this.nodeFilter = msg2.getFieldAsString(232L);
        this.tableDciName = msg2.getFieldAsString(600L);
        String s = msg2.getFieldAsString(446L);
        if (s != null && s.length() > 0) {
            String[] parts = s.split("\\^\\~\\^");
            this.columns = new ArrayList<DciSummaryTableColumn>(parts.length);
            for (int i = 0; i < parts.length; ++i) {
                int flags;
                String[] data = parts[i].split("\\^\\#\\^");
                if (data.length == 2) {
                    this.columns.add(new DciSummaryTableColumn(data[0], data[1], 0, ";"));
                    continue;
                }
                if (data.length < 3) continue;
                try {
                    flags = Integer.parseInt(data[2]);
                }
                catch (NumberFormatException e) {
                    flags = 0;
                }
                this.columns.add(new DciSummaryTableColumn(data[0], data[1], flags, data.length > 3 ? data[3] : ";"));
            }
        } else {
            this.columns = new ArrayList<DciSummaryTableColumn>(0);
        }
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(444L, this.id);
        msg2.setField(222L, this.guid);
        msg2.setField(445L, this.menuPath);
        msg2.setField(447L, this.title);
        msg2.setFieldInt32(13L, this.flags);
        msg2.setField(232L, this.nodeFilter);
        msg2.setField(600L, this.tableDciName);
        StringBuilder sb = new StringBuilder();
        for (DciSummaryTableColumn c : this.columns) {
            if (sb.length() > 0) {
                sb.append("^~^");
            }
            sb.append(c.getName());
            sb.append("^#^");
            sb.append(c.getDciName());
            sb.append("^#^");
            sb.append(c.getFlags());
            sb.append("^#^");
            sb.append(c.getSeparator());
        }
        msg2.setField(446L, sb.toString());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public void setMenuPath(String menuPath) {
        this.menuPath = menuPath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(String nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public List<DciSummaryTableColumn> getColumns() {
        return this.columns;
    }

    public boolean isMultiInstance() {
        return (this.flags & 1) != 0;
    }

    public boolean isTableSoure() {
        return (this.flags & 2) != 0;
    }

    public String getTableDciName() {
        return this.tableDciName != null ? this.tableDciName : "";
    }

    public void setTableDciName(String name) {
        this.tableDciName = name;
    }
}

