/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.WebServiceAuthType;

public class WebServiceDefinition {
    private final int FLAG_VERIFY_CERTIFICATE = 1;
    private final int FLAG_VERIFY_HOST = 2;
    private final int FLAG_PARSE_AS_TEXT = 4;
    private int id;
    private UUID guid;
    private String name;
    private String description;
    private String url;
    private WebServiceAuthType authenticationType;
    private String login;
    private String password;
    private int cacheRetentionTime;
    private int requestTimeout;
    private Map<String, String> headers;
    private int flags;

    public WebServiceDefinition(String name) {
        this.id = 0;
        this.guid = UUID.randomUUID();
        this.name = name;
        this.description = "";
        this.url = "";
        this.authenticationType = WebServiceAuthType.NONE;
        this.login = null;
        this.password = null;
        this.cacheRetentionTime = 0;
        this.requestTimeout = 0;
        this.headers = new HashMap<String, String>();
        this.flags = 3;
    }

    public WebServiceDefinition(NXCPMessage msg2) {
        this.id = msg2.getFieldAsInt32(680L);
        this.guid = msg2.getFieldAsUUID(222L);
        this.name = msg2.getFieldAsString(20L);
        this.description = msg2.getFieldAsString(27L);
        this.url = msg2.getFieldAsString(471L);
        this.authenticationType = WebServiceAuthType.getByValue(msg2.getFieldAsInt32(275L));
        this.login = msg2.getFieldAsString(1L);
        this.password = msg2.getFieldAsString(2L);
        this.cacheRetentionTime = msg2.getFieldAsInt32(45L);
        this.requestTimeout = msg2.getFieldAsInt32(627L);
        this.headers = msg2.getStringMapFromFields(0x20000000L, 676L);
        this.flags = msg2.getFieldAsInt32(13L);
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(680L, this.id);
        msg2.setField(222L, this.guid);
        msg2.setField(20L, this.name);
        msg2.setField(27L, this.description);
        msg2.setField(471L, this.url);
        msg2.setFieldInt16(275L, this.authenticationType.getValue());
        msg2.setField(1L, this.login);
        msg2.setField(2L, this.password);
        msg2.setFieldInt32(45L, this.cacheRetentionTime);
        msg2.setFieldInt32(627L, this.requestTimeout);
        msg2.setFieldsFromStringMap(this.headers, 0x20000000L, 676L);
        msg2.setFieldInt32(13L, this.flags);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String[] getHeaderNames() {
        return this.headers.keySet().toArray(new String[this.headers.size()]);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setGuid(UUID guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebServiceAuthType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(WebServiceAuthType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getCacheRetentionTime() {
        return this.cacheRetentionTime;
    }

    public void setCacheRetentionTime(int cacheRetentionTime) {
        this.cacheRetentionTime = cacheRetentionTime;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isVerifyCertificate() {
        return (this.flags & 1) > 0;
    }

    public void setVerifyCertificate(boolean verifyCertificate) {
        this.flags = verifyCertificate ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isVerifyHost() {
        return (this.flags & 2) > 0;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.flags = verifyHost ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setParseAsText(boolean useTextParsing) {
        this.flags = useTextParsing ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isTextParsingUsed() {
        return (this.flags & 4) > 0;
    }
}

