/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.constants.Severity;

public class EventTemplate {
    public static final int FLAG_WRITE_TO_LOG = 1;
    private long code;
    private UUID guid;
    private String name;
    private String message;
    private String description;
    private Severity severity;
    private int flags;
    private String tagList;
    private Set<String> tags;

    public EventTemplate(long code2) {
        this.code = code2;
        this.guid = NXCommon.EMPTY_GUID;
        this.name = "";
        this.message = "";
        this.description = "";
        this.severity = Severity.NORMAL;
        this.flags = 1;
        this.tagList = "";
        this.tags = new HashSet<String>();
    }

    public EventTemplate(NXCPMessage msg2, long baseId) {
        this.code = msg2.getFieldAsInt64(baseId + 1L);
        this.description = msg2.getFieldAsString(baseId + 2L);
        this.name = msg2.getFieldAsString(baseId + 3L);
        this.severity = Severity.getByValue(msg2.getFieldAsInt32(baseId + 4L));
        this.flags = msg2.getFieldAsInt32(baseId + 5L);
        this.message = msg2.getFieldAsString(baseId + 6L);
        this.tags = new HashSet<String>();
        this.tagList = msg2.getFieldAsString(baseId + 7L);
        if (this.tagList != null && !this.tagList.isEmpty()) {
            for (String s : this.tagList.split(",")) {
                this.tags.add(s);
            }
        }
        this.guid = msg2.getFieldAsUUID(baseId + 8L);
        if (this.guid == null) {
            this.guid = NXCommon.EMPTY_GUID;
        }
    }

    public EventTemplate(EventTemplate src) {
        this.code = src.code;
        this.guid = src.guid;
        this.name = src.name;
        this.description = src.description;
        this.severity = src.severity;
        this.flags = src.flags;
        this.message = src.message;
        this.tagList = src.tagList;
        this.tags = new HashSet<String>(src.tags);
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(24L, (int)this.code);
        msg2.setField(20L, this.name);
        msg2.setField(26L, this.message);
        msg2.setField(27L, this.description);
        msg2.setFieldInt32(25L, this.severity.getValue());
        msg2.setFieldInt32(13L, this.flags);
        if (!this.tags.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : this.tags) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            msg2.setField(645L, sb.toString());
        }
    }

    public void setAll(EventTemplate src) {
        this.code = src.code;
        this.guid = src.guid;
        this.name = src.name;
        this.message = src.message;
        this.description = src.description;
        this.severity = src.severity;
        this.flags = src.flags;
        this.tagList = src.tagList;
        this.tags = new HashSet<String>(src.tags);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message2) {
        this.message = message2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCode() {
        return this.code;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setCode(long code2) {
        this.code = code2;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
        if (!tags.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : tags) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            this.tagList = sb.toString();
        } else {
            this.tagList = "";
        }
    }

    public String getTagList() {
        return this.tagList != null ? this.tagList : "";
    }

    public String toString() {
        return "EventTemplate [code=" + this.code + ", name=" + this.name + ", message=" + this.message + ", description=" + this.description + ", severity=" + (Object)((Object)this.severity) + ", flags=" + this.flags + ", tagList=" + this.tagList + ", tags=" + this.tags + "]";
    }
}

