/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.packages;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.netxms.base.NXCPMessage;

public class PackageInfo {
    private long id;
    private String name;
    private String description;
    private String fileName;
    private String platform;
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInfo(File npiFile) throws IOException {
        this.id = 0L;
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(npiFile));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("NAME ")) {
                    this.name = line.substring(5).trim();
                    continue;
                }
                if (line.startsWith("PLATFORM ")) {
                    this.platform = line.substring(9).trim();
                    continue;
                }
                if (line.startsWith("VERSION ")) {
                    this.version = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("DESCRIPTION ")) {
                    this.description = line.substring(12).trim();
                    continue;
                }
                if (!line.startsWith("FILE ")) continue;
                this.fileName = line.substring(5).trim();
            }
        }
    }

    public PackageInfo(NXCPMessage msg2) {
        this.id = msg2.getFieldAsInt64(126L);
        this.name = msg2.getFieldAsString(129L);
        this.description = msg2.getFieldAsString(27L);
        this.fileName = msg2.getFieldAsString(125L);
        this.platform = msg2.getFieldAsString(128L);
        this.version = msg2.getFieldAsString(127L);
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(126L, (int)this.id);
        msg2.setField(129L, this.name);
        msg2.setField(27L, this.description);
        msg2.setField(125L, this.fileName);
        msg2.setField(128L, this.platform);
        msg2.setField(127L, this.version);
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }
}

