/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.reporting.ReportParameter;

public class ReportDefinition {
    private UUID id;
    private String name;
    private int numberOfColumns = 1;
    private List<ReportParameter> parameters = new ArrayList<ReportParameter>(0);

    public ReportDefinition(UUID id, NXCPMessage msg2) {
        this.id = id;
        this.name = msg2.getFieldAsString(20L);
        this.numberOfColumns = msg2.getFieldAsInt32(166L);
        int count2 = msg2.getFieldAsInt32(111L);
        long varId = 0x30000000L;
        int i = 0;
        while (i < count2) {
            this.parameters.add(new ReportParameter(msg2, varId));
            ++i;
            varId += 10L;
        }
        Collections.sort(this.parameters, new Comparator<ReportParameter>(){

            @Override
            public int compare(ReportParameter o1, ReportParameter o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<ReportParameter> getParameters() {
        return this.parameters;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String toString() {
        return "ReportDefinition [id=" + this.id + ", name=" + this.name + ", numberOfColumns=" + this.numberOfColumns + ", parameters=" + this.parameters + "]";
    }
}

