/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.server;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class ServerFile {
    private String name;
    private long size;
    private Date modificationTime;
    private String extension;

    public ServerFile(NXCPMessage msg2, long baseId) {
        this.name = msg2.getFieldAsString(baseId);
        this.size = msg2.getFieldAsInt64(baseId + 1L);
        this.modificationTime = msg2.getFieldAsDate(baseId + 2L);
        this.setExtension();
    }

    private void setExtension() {
        if (this.name.startsWith(".")) {
            this.extension = " ";
            return;
        }
        String[] parts = this.name.split("\\.");
        this.extension = parts.length > 1 ? parts[parts.length - 1] : " ";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setExtension();
    }

    public long getSize() {
        return this.size;
    }

    public Date getModifyicationTime() {
        return this.modificationTime;
    }

    public String getExtension() {
        return this.extension;
    }
}

