/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.netxms.base.EncryptionContext;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;

public class NXCPMessageReceiver {
    private int defaultBufferSize;
    private int maxBufferSize;
    private byte[] recvBuffer;
    private int bufferPos = 0;

    public String toString() {
        return "NXCPMessageReceiver [defaultBufferSize=" + this.defaultBufferSize + " maxBufferSize=" + this.maxBufferSize + " recvBuffer=" + this.recvBuffer + " bufferPos=" + this.bufferPos;
    }

    public NXCPMessageReceiver(int defaultBufferSize, int maxBufferSize) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxBufferSize = maxBufferSize;
        this.recvBuffer = new byte[defaultBufferSize];
    }

    private long getMessageSize(byte[] header2) {
        return (long)header2[4] << 24 & 0xFFFFFFFFFF000000L | (long)header2[5] << 16 & 0xFF0000L | (long)header2[6] << 8 & 0xFF00L | (long)header2[7] & 0xFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NXCPMessage getMessageFromBuffer(EncryptionContext ectx) throws IOException, NXCPException {
        NXCPMessage msg2 = null;
        if (this.bufferPos >= 16) {
            long size = this.getMessageSize(this.recvBuffer);
            if (size <= (long)this.bufferPos) {
                try {
                    msg2 = new NXCPMessage(this.recvBuffer, ectx);
                }
                finally {
                    System.arraycopy(this.recvBuffer, (int)size, this.recvBuffer, 0, this.bufferPos - (int)size);
                    this.bufferPos = (int)((long)this.bufferPos - size);
                    if (this.recvBuffer.length > this.defaultBufferSize && this.bufferPos < this.defaultBufferSize) {
                        this.recvBuffer = Arrays.copyOf(this.recvBuffer, this.defaultBufferSize);
                    }
                }
            } else if (size > (long)this.recvBuffer.length) {
                if (size <= (long)this.maxBufferSize) {
                    this.recvBuffer = Arrays.copyOf(this.recvBuffer, (int)size);
                } else {
                    throw new NXCPException(1);
                }
            }
        }
        return msg2;
    }

    public NXCPMessage receiveMessage(InputStream in, EncryptionContext ectx) throws IOException, NXCPException {
        NXCPMessage msg2 = null;
        while ((msg2 = this.getMessageFromBuffer(ectx)) == null) {
            int bytes = in.read(this.recvBuffer, this.bufferPos, this.recvBuffer.length - this.bufferPos);
            if (bytes == -1) {
                throw new NXCPException(2);
            }
            this.bufferPos += bytes;
        }
        return msg2;
    }
}

