/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.UUID;
import org.netxms.base.NXCPMessage;

public class AgentPolicy {
    public static final String AGENT_CONFIG = "AgentConfig";
    public static final String FILE_DELIVERY = "FileDelivery";
    public static final String LOG_PARSER = "LogParserConfig";
    public static final String SUPPORT_APPLICATION = "SupportApplicationConfig";
    public static final long EXPAND_MACRO = 1L;
    private UUID guid;
    private String name;
    private String policyType;
    private String content;
    private int flags;

    public AgentPolicy(NXCPMessage msg2) {
        this.guid = msg2.getFieldAsUUID(222L);
        this.name = msg2.getFieldAsString(20L);
        this.policyType = msg2.getFieldAsString(336L);
        this.content = msg2.getFieldAsString(81L);
        this.flags = msg2.getFieldAsInt32(13L);
    }

    public AgentPolicy(String policyName, String policyType) {
        this.guid = null;
        this.name = policyName;
        this.policyType = policyType;
        this.content = "";
    }

    public AgentPolicy(NXCPMessage msg2, long base2) {
        this.guid = msg2.getFieldAsUUID(base2);
        this.policyType = msg2.getFieldAsString(base2 + 1L);
        this.name = msg2.getFieldAsString(base2 + 2L);
        this.content = msg2.getFieldAsString(base2 + 3L);
        this.flags = msg2.getFieldAsInt32(base2 + 4L);
    }

    public AgentPolicy(AgentPolicy policy) {
        this.guid = null;
        this.name = policy.name;
        this.policyType = policy.policyType;
        this.content = policy.content;
        this.flags = policy.flags;
    }

    public void fillMessage(NXCPMessage msg2) {
        if (this.guid != null) {
            msg2.setField(222L, this.guid);
        }
        msg2.setField(20L, this.name);
        msg2.setField(336L, this.policyType);
        msg2.setField(81L, this.content);
        msg2.setFieldInt32(13L, this.flags);
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setGuid(UUID newObjectGuid) {
        this.guid = newObjectGuid;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String toString() {
        return this.name;
    }

    public void update(AgentPolicy object) {
        this.guid = object.guid;
        this.name = object.name;
        this.policyType = object.policyType;
        this.content = object.content;
        this.flags = object.flags;
    }
}

