/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.HardwareComponentCategory;

public class HardwareComponent {
    private HardwareComponentCategory category;
    private int index;
    private long capacity;
    private String type;
    private String vendor;
    private String model;
    private String partNumber;
    private String serialNumber;
    private String location;
    private String description;

    public HardwareComponent(NXCPMessage msg2, long baseId) {
        this.category = HardwareComponentCategory.getByValue(msg2.getFieldAsInt32(baseId));
        this.index = msg2.getFieldAsInt32(baseId + 1L);
        this.type = msg2.getFieldAsString(baseId + 2L);
        this.vendor = msg2.getFieldAsString(baseId + 3L);
        this.model = msg2.getFieldAsString(baseId + 4L);
        this.location = msg2.getFieldAsString(baseId + 5L);
        this.capacity = msg2.getFieldAsInt64(baseId + 6L);
        this.partNumber = msg2.getFieldAsString(baseId + 7L);
        this.serialNumber = msg2.getFieldAsString(baseId + 8L);
        this.description = msg2.getFieldAsString(baseId + 9L);
    }

    public HardwareComponentCategory getCategory() {
        return this.category;
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }
}

