/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class ScheduledTask {
    private long id;
    private String taskHandlerId;
    private String key;
    private String schedule;
    private String parameters;
    private String comments;
    private Date executionTime;
    private Date lastExecutionTime;
    private int flags;
    private long owner;
    private long objectId;
    public static final int DISABLED = 1;
    public static final int EXECUTED = 2;
    public static final int RUNNING = 4;
    public static final int SYSTEM = 8;
    private static final String[] statusDescription = new String[]{"Disabled", "Completed", "Running"};

    public ScheduledTask() {
        this.id = 0L;
        this.taskHandlerId = "";
        this.key = "";
        this.schedule = "";
        this.parameters = "";
        this.executionTime = new Date();
        this.lastExecutionTime = new Date();
        this.flags = 0;
        this.owner = 0L;
        this.objectId = 0L;
        this.comments = "";
    }

    public ScheduledTask(NXCPMessage msg2, long base2) {
        this.id = msg2.getFieldAsInt64(base2);
        this.taskHandlerId = msg2.getFieldAsString(base2 + 1L);
        this.schedule = msg2.getFieldAsString(base2 + 2L);
        this.parameters = msg2.getFieldAsString(base2 + 3L);
        this.executionTime = msg2.getFieldAsDate(base2 + 4L);
        this.lastExecutionTime = msg2.getFieldAsDate(base2 + 5L);
        this.flags = msg2.getFieldAsInt32(base2 + 6L);
        this.owner = msg2.getFieldAsInt64(base2 + 7L);
        this.objectId = msg2.getFieldAsInt64(base2 + 8L);
        this.comments = msg2.getFieldAsString(base2 + 9L);
        this.key = msg2.getFieldAsString(base2 + 10L);
    }

    public ScheduledTask(String taskHandlerId, String schedule, String parameters, String comments, Date executionTime, int flags, long objectId) {
        this.id = 0L;
        this.taskHandlerId = taskHandlerId;
        this.key = "";
        this.schedule = schedule;
        this.parameters = parameters;
        this.executionTime = executionTime;
        this.lastExecutionTime = new Date(0L);
        this.flags = flags;
        this.owner = 0L;
        this.objectId = objectId;
        this.comments = comments;
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(522L, (int)this.id);
        msg2.setField(523L, this.taskHandlerId);
        if (this.schedule.isEmpty()) {
            msg2.setField(525L, this.executionTime);
        } else {
            msg2.setField(524L, this.schedule);
        }
        msg2.setField(85L, this.parameters);
        msg2.setField(526L, this.lastExecutionTime);
        msg2.setFieldInt32(13L, this.flags);
        msg2.setField(694L, this.isDisabled());
        msg2.setFieldInt32(3L, (int)this.objectId);
        msg2.setField(82L, this.comments);
        msg2.setField(623L, this.key);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTaskHandlerId() {
        return this.taskHandlerId;
    }

    public void setTaskHandlerId(String taskHandlerId) {
        this.taskHandlerId = taskHandlerId;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(Date executionTime) {
        this.executionTime = executionTime;
    }

    public Date getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public void setLastExecutionTime(Date lastExecutionTime) {
        this.lastExecutionTime = lastExecutionTime;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public long getOwner() {
        return this.owner;
    }

    public void setOwner(long owner) {
        this.owner = owner;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getStatus() {
        if ((this.flags & 4) != 0) {
            return statusDescription[2];
        }
        if ((this.flags & 2) != 0) {
            return statusDescription[1];
        }
        if ((this.flags & 1) != 0) {
            return statusDescription[0];
        }
        return "";
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isSystem() {
        return (this.flags & 8) != 0;
    }

    public boolean isCompleted() {
        return (this.flags & 2) != 0;
    }

    public boolean isDisabled() {
        return (this.flags & 1) != 0;
    }

    public boolean isRecurring() {
        return this.schedule != null && !this.schedule.isEmpty();
    }

    public void setEnabed(boolean enabled) {
        this.flags = enabled ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
    }
}

