/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Arrays;
import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;

public class UserAgentNotification {
    private long id;
    private String message;
    private long[] objects;
    private String objectNames;
    private Date startTime;
    private Date endTime;
    private boolean recalled;
    private boolean onStartup;
    private Date creationTime;
    private long createdBy;

    public UserAgentNotification(NXCPMessage msg2, long baseId, NXCSession session) {
        this.id = msg2.getFieldAsInt32(baseId);
        this.message = msg2.getFieldAsString(baseId + 1L);
        this.startTime = msg2.getFieldAsDate(baseId + 2L);
        this.endTime = msg2.getFieldAsDate(baseId + 3L);
        this.onStartup = msg2.getFieldAsBoolean(baseId + 4L);
        this.objects = msg2.getFieldAsUInt32Array(baseId + 5L);
        Arrays.sort(this.objects);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.objects.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(session.getObjectName(this.objects[i]));
        }
        this.objectNames = sb.toString();
        this.recalled = msg2.getFieldAsBoolean(baseId + 6L);
        this.creationTime = msg2.getFieldAsDate(baseId + 7L);
        this.createdBy = msg2.getFieldAsInt64(baseId + 8L);
    }

    public long getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public long[] getObjects() {
        return this.objects;
    }

    public String getObjectNames() {
        return this.objectNames;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isRecalled() {
        return this.recalled;
    }

    public boolean isStartupNotification() {
        return this.onStartup;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public long getCreatedBy() {
        return this.createdBy;
    }
}

