/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.WinPerfCounter;

public class WinPerfObject {
    private String name;
    private List<WinPerfCounter> counters;
    private List<String> instances;

    public static List<WinPerfObject> createListFromMessage(NXCPMessage msg2) {
        int count2 = msg2.getFieldAsInt32(138L);
        ArrayList<WinPerfObject> objects = new ArrayList<WinPerfObject>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            WinPerfObject o = new WinPerfObject(msg2, varId);
            varId += (long)(o.counters.size() + o.instances.size() + 3);
            objects.add(o);
        }
        return objects;
    }

    private WinPerfObject(NXCPMessage msg2, long baseId) {
        int i;
        this.name = msg2.getFieldAsString(baseId);
        int count2 = msg2.getFieldAsInt32(baseId + 1L);
        this.counters = new ArrayList<WinPerfCounter>(count2);
        long varId = baseId + 3L;
        for (i = 0; i < count2; ++i) {
            this.counters.add(new WinPerfCounter(this, msg2.getFieldAsString(varId++)));
        }
        count2 = msg2.getFieldAsInt32(baseId + 2L);
        this.instances = new ArrayList<String>(count2);
        for (i = 0; i < count2; ++i) {
            this.instances.add(msg2.getFieldAsString(varId++));
        }
    }

    public String getName() {
        return this.name;
    }

    public WinPerfCounter[] getCounters() {
        return this.counters.toArray(new WinPerfCounter[this.counters.size()]);
    }

    public String[] getInstances() {
        return this.instances.toArray(new String[this.instances.size()]);
    }

    public boolean hasCounters() {
        return this.counters.size() > 0;
    }

    public boolean hasInstances() {
        return this.instances.size() > 0;
    }
}

