/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Arrays;
import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;

public class Alarm {
    public static final int STATE_OUTSTANDING = 0;
    public static final int STATE_ACKNOWLEDGED = 1;
    public static final int STATE_RESOLVED = 2;
    public static final int STATE_TERMINATED = 3;
    public static final int STATE_MASK = 15;
    public static final int HELPDESK_STATE_IGNORED = 0;
    public static final int HELPDESK_STATE_OPEN = 1;
    public static final int HELPDESK_STATE_CLOSED = 2;
    private long id;
    private long parentId;
    private Severity currentSeverity;
    private Severity originalSeverity;
    private int repeatCount;
    private int state;
    private boolean sticky;
    private int acknowledgedByUser;
    private int resolvedByUser;
    private int terminatedByUser;
    private long sourceEventId;
    private int sourceEventCode;
    private long sourceObjectId;
    private long dciId;
    private Date creationTime;
    private Date lastChangeTime;
    private String message;
    private String key;
    private int helpdeskState;
    private String helpdeskReference;
    private int timeout;
    private int timeoutEvent;
    private int commentsCount;
    private int ackTime;
    private long[] categories;
    private long[] subordinateAlarms;

    public Alarm(NXCPMessage msg2) {
        this.id = msg2.getFieldAsInt64(93L);
        this.parentId = msg2.getFieldAsInt64(669L);
        this.currentSeverity = Severity.getByValue(msg2.getFieldAsInt32(244L));
        this.originalSeverity = Severity.getByValue(msg2.getFieldAsInt32(245L));
        this.repeatCount = msg2.getFieldAsInt32(248L);
        this.state = msg2.getFieldAsInt32(243L);
        this.sticky = msg2.getFieldAsBoolean(420L);
        this.acknowledgedByUser = msg2.getFieldAsInt32(95L);
        this.resolvedByUser = msg2.getFieldAsInt32(419L);
        this.terminatedByUser = msg2.getFieldAsInt32(242L);
        this.sourceEventId = msg2.getFieldAsInt64(123L);
        this.sourceEventCode = msg2.getFieldAsInt32(24L);
        this.sourceObjectId = msg2.getFieldAsInt64(3L);
        this.dciId = msg2.getFieldAsInt64(43L);
        this.creationTime = new Date(msg2.getFieldAsInt64(240L) * 1000L);
        this.lastChangeTime = new Date(msg2.getFieldAsInt64(241L) * 1000L);
        this.message = msg2.getFieldAsString(66L);
        this.key = msg2.getFieldAsString(64L);
        this.helpdeskState = msg2.getFieldAsInt32(246L);
        this.helpdeskReference = msg2.getFieldAsString(247L);
        this.timeout = msg2.getFieldAsInt32(65L);
        this.timeoutEvent = msg2.getFieldAsInt32(283L);
        this.commentsCount = msg2.getFieldAsInt32(409L);
        this.ackTime = msg2.getFieldAsInt32(94L);
        this.categories = msg2.getFieldAsUInt32Array(641L);
        this.subordinateAlarms = msg2.getFieldAsUInt32Array(671L);
    }

    public void setResolved(int userId, Date changeTime) {
        this.state = 2;
        this.lastChangeTime = changeTime;
        this.resolvedByUser = userId;
    }

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public Severity getCurrentSeverity() {
        return this.currentSeverity;
    }

    public Severity getOriginalSeverity() {
        return this.originalSeverity;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getState() {
        return this.state;
    }

    public int getAcknowledgedByUser() {
        return this.acknowledgedByUser;
    }

    public int getTerminatedByUser() {
        return this.terminatedByUser;
    }

    public long getSourceEventId() {
        return this.sourceEventId;
    }

    public int getSourceEventCode() {
        return this.sourceEventCode;
    }

    public long getSourceObjectId() {
        return this.sourceObjectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastChangeTime() {
        return this.lastChangeTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String getKey() {
        return this.key;
    }

    public int getHelpdeskState() {
        return this.helpdeskState;
    }

    public String getHelpdeskReference() {
        return this.helpdeskReference;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTimeoutEvent() {
        return this.timeoutEvent;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public int getResolvedByUser() {
        return this.resolvedByUser;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public int getAckTime() {
        return this.ackTime;
    }

    public long[] getCategories() {
        return this.categories != null ? this.categories : new long[]{};
    }

    public long[] getSubordinateAlarms() {
        return this.subordinateAlarms != null ? this.subordinateAlarms : new long[]{};
    }

    public boolean hasSubordinatedAlarms() {
        return this.subordinateAlarms != null && this.subordinateAlarms.length > 0;
    }

    public String toString() {
        return "Alarm [id=" + this.id + ", parentId=" + this.parentId + ", currentSeverity=" + (Object)((Object)this.currentSeverity) + ", originalSeverity=" + (Object)((Object)this.originalSeverity) + ", repeatCount=" + this.repeatCount + ", state=" + this.state + ", sticky=" + this.sticky + ", acknowledgedByUser=" + this.acknowledgedByUser + ", resolvedByUser=" + this.resolvedByUser + ", terminatedByUser=" + this.terminatedByUser + ", sourceEventId=" + this.sourceEventId + ", sourceEventCode=" + this.sourceEventCode + ", sourceObjectId=" + this.sourceObjectId + ", dciId=" + this.dciId + ", creationTime=" + this.creationTime + ", lastChangeTime=" + this.lastChangeTime + ", message=" + this.message + ", key=" + this.key + ", helpdeskState=" + this.helpdeskState + ", helpdeskReference=" + this.helpdeskReference + ", timeout=" + this.timeout + ", timeoutEvent=" + this.timeoutEvent + ", commentsCount=" + this.commentsCount + ", ackTime=" + this.ackTime + ", categories=" + Arrays.toString(this.categories) + ", subordinateAlarms=" + Arrays.toString(this.subordinateAlarms) + "]";
    }
}

