/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.server;

import java.util.HashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.ServerVariableDataType;

public final class ServerVariable {
    private String name;
    private String value;
    private String defaultValue;
    private String description;
    private ServerVariableDataType dataType;
    private HashMap<String, String> values = new HashMap();
    private boolean isServerRestartNeeded;
    private String unit;

    public ServerVariable(String name, String value, boolean isServerRestartNeeded, ServerVariableDataType dataType, String description, String unit) {
        this.name = name;
        this.value = value;
        this.defaultValue = value;
        this.description = description;
        this.dataType = dataType;
        this.isServerRestartNeeded = isServerRestartNeeded;
        this.unit = unit;
    }

    public ServerVariable(NXCPMessage msg2, long baseId) {
        this.name = msg2.getFieldAsString(baseId);
        this.value = msg2.getFieldAsString(baseId + 1L);
        this.isServerRestartNeeded = msg2.getFieldAsBoolean(baseId + 2L);
        String code2 = msg2.getFieldAsString(baseId + 3L);
        this.dataType = ServerVariableDataType.getByCode(code2 != null && !code2.isEmpty() ? code2.charAt(0) : (char)'S');
        this.description = msg2.getFieldAsString(baseId + 4L);
        this.defaultValue = msg2.getFieldAsString(baseId + 5L);
        this.unit = msg2.getFieldAsString(baseId + 6L);
    }

    public void addPossibleValue(NXCPMessage msg2, long baseId) {
        this.values.put(msg2.getFieldAsString(baseId), msg2.getFieldAsString(baseId + 1L));
    }

    public String getName() {
        return this.name;
    }

    public String getValueForDisplay() {
        if (this.value == null) {
            return "";
        }
        if (this.dataType != ServerVariableDataType.CHOICE) {
            return this.value;
        }
        String s = this.values.get(this.value);
        return s != null ? s : this.value;
    }

    public String getValue() {
        return this.value != null ? this.value : "";
    }

    public boolean getValueAsBoolean() {
        try {
            return Integer.parseInt(this.value) != 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int getValueAsInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public ServerVariableDataType getDataType() {
        return this.dataType;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isServerRestartNeeded() {
        return this.isServerRestartNeeded;
    }

    public HashMap<String, String> getPossibleValues() {
        return this.values;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueForDisplay() {
        if (this.defaultValue == null) {
            return "";
        }
        if (this.dataType != ServerVariableDataType.CHOICE) {
            return this.defaultValue;
        }
        String s = this.values.get(this.defaultValue);
        return s != null ? s : this.defaultValue;
    }

    public boolean isDefault() {
        return this.value.equals(this.defaultValue);
    }

    public String getUnit() {
        return this.unit;
    }
}

