/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpTrapParameterMapping;

public class SnmpTrap {
    private long id;
    private String description;
    private SnmpObjectId objectId;
    private int eventCode;
    private String eventTag;
    private String transformationScript;
    private List<SnmpTrapParameterMapping> parameterMapping;

    public SnmpTrap() {
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>();
    }

    public SnmpTrap(NXCPMessage msg2) {
        this.id = msg2.getFieldAsInt64(117L);
        this.description = msg2.getFieldAsString(27L);
        this.objectId = new SnmpObjectId(msg2.getFieldAsUInt32Array(118L));
        this.eventCode = msg2.getFieldAsInt32(24L);
        this.eventTag = msg2.getFieldAsString(298L);
        this.transformationScript = msg2.getFieldAsString(106L);
        int count2 = msg2.getFieldAsInt32(120L);
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>(count2);
        long base2 = 36864L;
        int i = 0;
        while (i < count2) {
            this.parameterMapping.add(new SnmpTrapParameterMapping(msg2, base2));
            ++i;
            base2 += 10L;
        }
    }

    public SnmpTrap(NXCPMessage msg2, long baseId) {
        this.id = msg2.getFieldAsInt64(baseId);
        this.description = msg2.getFieldAsString(baseId + 1L);
        this.objectId = new SnmpObjectId(msg2.getFieldAsUInt32Array(baseId + 2L));
        this.eventCode = msg2.getFieldAsInt32(baseId + 3L);
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>(0);
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(117L, (int)this.id);
        msg2.setFieldInt32(24L, this.eventCode);
        msg2.setField(27L, this.description);
        msg2.setField(298L, this.eventTag);
        msg2.setFieldInt32(119L, this.objectId.getLength());
        this.objectId.setNXCPVariable(msg2, 118L);
        msg2.setField(106L, this.transformationScript);
        msg2.setFieldInt32(120L, this.parameterMapping.size());
        long base2 = 36864L;
        int i = 0;
        while (i < this.parameterMapping.size()) {
            this.parameterMapping.get(i).fillMessage(msg2, base2);
            ++i;
            base2 += 10L;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SnmpObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(SnmpObjectId objectId) {
        this.objectId = objectId;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public String getEventTag() {
        return this.eventTag;
    }

    public void setEventTag(String eventTag) {
        this.eventTag = eventTag;
    }

    public String getTransformationScript() {
        return this.transformationScript;
    }

    public void setTransformationScript(String transformationScript) {
        this.transformationScript = transformationScript;
    }

    public List<SnmpTrapParameterMapping> getParameterMapping() {
        return this.parameterMapping;
    }
}

