/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.base.annotations.Internal;
import org.netxms.client.objects.AccessPoint;

public class RadioInterface {
    @Internal
    private AccessPoint accessPoint;
    private int index;
    private String name;
    private MacAddress macAddress;
    private int channel;
    private int powerDBm;
    private int powerMW;

    public RadioInterface(AccessPoint ap, NXCPMessage msg2, long baseId) {
        this.accessPoint = ap;
        this.index = msg2.getFieldAsInt32(baseId);
        this.name = msg2.getFieldAsString(baseId + 1L);
        this.macAddress = new MacAddress(msg2.getFieldAsBinary(baseId + 2L));
        this.channel = msg2.getFieldAsInt32(baseId + 3L);
        this.powerDBm = msg2.getFieldAsInt32(baseId + 4L);
        this.powerMW = msg2.getFieldAsInt32(baseId + 5L);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getPowerDBm() {
        return this.powerDBm;
    }

    public int getPowerMW() {
        return this.powerMW;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }
}

