/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.users;

import org.netxms.base.NXCPMessage;
import org.netxms.client.users.AbstractUserObject;

public class UserGroup
extends AbstractUserObject {
    private long[] members;

    public UserGroup(String name) {
        super(name, "group");
        this.members = new long[0];
    }

    public UserGroup(UserGroup src) {
        super(src);
        this.members = new long[src.members.length];
        System.arraycopy(src.members, 0, this.members, 0, src.members.length);
    }

    public UserGroup(NXCPMessage msg2) {
        super(msg2, "group");
        int count2 = msg2.getFieldAsInt32(38L);
        this.members = new long[count2];
        for (int i = 0; i < count2; ++i) {
            this.members[i] = msg2.getFieldAsInt64(16384L + (long)i);
        }
    }

    @Override
    public void fillMessage(NXCPMessage msg2) {
        super.fillMessage(msg2);
        msg2.setFieldInt32(38L, this.members.length);
        for (int i = 0; i < this.members.length; ++i) {
            msg2.setFieldInt32(16384L + (long)i, (int)this.members[i]);
        }
    }

    public long[] getMembers() {
        return this.members;
    }

    public void setMembers(long[] members) {
        this.members = members;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new UserGroup(this);
    }
}

