/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.UUID;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.websvc.handlers.AbstractHandler;

public class AbstractObjectHandler
extends AbstractHandler {
    protected AbstractObject getObject() throws Exception {
        AbstractObject object;
        NXCSession session = this.getSession();
        if (!session.areObjectsSynchronized()) {
            session.syncObjects();
        }
        String entityId = (String)this.getRequest().getAttributes().get("object-id");
        try {
            long objectId = Long.parseLong(entityId);
            object = session.findObjectById(objectId);
        }
        catch (NumberFormatException e) {
            UUID objectGuid = UUID.fromString(entityId);
            object = session.findObjectByGUID(objectGuid);
        }
        if (object == null) {
            throw new NXCException(7);
        }
        return object;
    }

    protected long getObjectId() throws Exception {
        return this.getObject().getObjectId();
    }

    protected UUID getObjectGuid() throws Exception {
        return this.getObject().getGuid();
    }
}

