/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ObjectSelector
extends AbstractSelector {
    private long objectId = 0L;
    private AbstractObject object = null;
    private Set<Class<? extends AbstractObject>> objectClassSet = new HashSet<Class<? extends AbstractObject>>();
    private Set<Integer> classFilter = null;
    private String emptySelectionName;

    public ObjectSelector(Composite parent, int style, boolean showClearButton) {
        super(parent, style, showClearButton ? 8 : 0);
        Messages.get();
        this.emptySelectionName = Messages.ObjectSelector_None;
        this.setText(this.emptySelectionName);
        this.objectClassSet.add(Node.class);
    }

    protected void selectionButtonHandler() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), this.classFilter);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractObject[] objects = dlg.getSelectedObjects(this.objectClassSet);
            if (objects.length > 0) {
                this.objectId = objects[0].getObjectId();
                this.object = objects[0];
                this.setText(objects[0].getNameWithAlias());
            } else {
                this.objectId = 0L;
                this.object = null;
                this.setText(this.emptySelectionName);
            }
            this.fireModifyListeners();
        }
    }

    protected void clearButtonHandler() {
        this.objectId = 0L;
        this.object = null;
        this.setText(this.emptySelectionName);
        this.fireModifyListeners();
    }

    public long getObjectId() {
        return this.objectId;
    }

    public AbstractObject getObject() {
        return this.object;
    }

    public String getObjectName() {
        return this.getText();
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
        if (objectId == 0L) {
            this.setText(this.emptySelectionName);
        } else {
            this.object = ConsoleSharedData.getSession().findObjectById(objectId);
            this.setText(this.object != null ? this.object.getObjectName() : "<" + Long.toString(objectId) + ">");
        }
    }

    public Class<? extends AbstractObject> getObjectClass() {
        return this.objectClassSet.iterator().next();
    }

    public void setObjectClass(Class<? extends AbstractObject> objectClass) {
        this.objectClassSet.clear();
        this.objectClassSet.add(objectClass);
    }

    public void setObjectClass(Set<Class<? extends AbstractObject>> filterSet) {
        this.objectClassSet = filterSet;
    }

    public String getEmptySelectionName() {
        return this.emptySelectionName;
    }

    public void setEmptySelectionName(String emptySelectionName) {
        this.emptySelectionName = emptySelectionName;
        if (this.objectId == 0L) {
            this.setText(emptySelectionName);
        }
    }

    public Set<Integer> getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Set<Integer> classFilter) {
        this.classFilter = classFilter;
    }
}

