/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptSelector;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.AddAddressListElementDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.AddressListElementComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.AddressListLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.NetworkDiscoveryConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.Section;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NetworkDiscoveryConfigurator
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.NetworkDiscoveryConfigurator";
    public static final int RANGE = 0;
    public static final int PROXY = 1;
    public static final int COMMENTS = 2;
    private NetworkDiscoveryConfig config;
    private boolean modified = false;
    private Composite content;
    private Button radioDiscoveryOff;
    private Button radioDiscoveryPassive;
    private Button radioDiscoveryActive;
    private Button radioDiscoveryActiveAndPassive;
    private Button checkUseSnmpTraps;
    private Button checkUseSyslog;
    private Spinner passiveDiscoveryInterval;
    private Label activeDiscoveryScheduleLabel;
    private Button radioActiveDiscoveryInterval;
    private Button radioActiveDiscoverySchedule;
    private Spinner activeDiscoveryInterval;
    private LabeledText activeDiscoverySchedule;
    private Button checkFilterRange;
    private Button checkFilterProtocols;
    private Button checkAllowAgent;
    private Button checkAllowSNMP;
    private Button checkAllowSSH;
    private Button checkFilterScript;
    private ScriptSelector filterScript;
    private SortableTableViewer filterAddressList;
    private SortableTableViewer activeDiscoveryAddressList;
    private Action actionSave;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void createPartControl(Composite parent) {
        final ScrolledComposite scroller = new ScrolledComposite(parent, 512);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)scroller, (int)512, (int)20);
        scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                NetworkDiscoveryConfigurator.this.content.layout(true, true);
                scroller.setMinSize(NetworkDiscoveryConfigurator.this.content.computeSize(scroller.getSize().x, -1));
            }
        });
        this.content = new Composite((Composite)scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(this.content.getDisplay().getSystemColor(25));
        scroller.setContent((Control)this.content);
        this.createGeneralSection();
        this.createFilterSection();
        this.createScheduleSection();
        this.createActiveDiscoverySection();
        this.createActions();
        this.contributeToActionBars();
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.NetworkDiscoveryConfigurator_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final NetworkDiscoveryConfig loadedConfig = NetworkDiscoveryConfig.load(session);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkDiscoveryConfigurator.this.setConfig(loadedConfig);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkDiscoveryConfigurator_LoadJobError;
            }
        }.start();
    }

    private void createActions() {
        Messages.get();
        this.actionSave = new Action(Messages.NetworkDiscoveryConfigurator_Save, SharedIcons.SAVE){

            public void run() {
                NetworkDiscoveryConfigurator.this.save();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void createGeneralSection() {
        Messages.get();
        Section section = new Section(this.content, Messages.NetworkDiscoveryConfigurator_SectionGeneral, false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.setModified();
                if (NetworkDiscoveryConfigurator.this.radioDiscoveryOff.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setDiscoveryType(0);
                    NetworkDiscoveryConfigurator.this.enableActiveDiscovery(false);
                    NetworkDiscoveryConfigurator.this.enablePassiveDiscovery(false);
                } else if (NetworkDiscoveryConfigurator.this.radioDiscoveryPassive.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setDiscoveryType(1);
                    NetworkDiscoveryConfigurator.this.enableActiveDiscovery(false);
                    NetworkDiscoveryConfigurator.this.enablePassiveDiscovery(true);
                } else if (NetworkDiscoveryConfigurator.this.radioDiscoveryActive.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setDiscoveryType(2);
                    NetworkDiscoveryConfigurator.this.enableActiveDiscovery(true);
                    NetworkDiscoveryConfigurator.this.enablePassiveDiscovery(false);
                } else if (NetworkDiscoveryConfigurator.this.radioDiscoveryActiveAndPassive.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setDiscoveryType(3);
                    NetworkDiscoveryConfigurator.this.enableActiveDiscovery(true);
                    NetworkDiscoveryConfigurator.this.enablePassiveDiscovery(true);
                }
            }
        };
        this.radioDiscoveryOff = new Button(clientArea, 16);
        Messages.get();
        this.radioDiscoveryOff.setText(Messages.NetworkDiscoveryConfigurator_Disabled);
        this.radioDiscoveryOff.addSelectionListener((SelectionListener)listener);
        this.radioDiscoveryPassive = new Button(clientArea, 16);
        Messages.get();
        this.radioDiscoveryPassive.setText(Messages.NetworkDiscoveryConfigurator_PassiveDiscovery);
        this.radioDiscoveryPassive.addSelectionListener((SelectionListener)listener);
        this.radioDiscoveryActive = new Button(clientArea, 16);
        this.radioDiscoveryActive.setText("Active only");
        this.radioDiscoveryActive.addSelectionListener((SelectionListener)listener);
        this.radioDiscoveryActiveAndPassive = new Button(clientArea, 16);
        Messages.get();
        this.radioDiscoveryActiveAndPassive.setText(Messages.NetworkDiscoveryConfigurator_ActiveDiscovery);
        this.radioDiscoveryActiveAndPassive.addSelectionListener((SelectionListener)listener);
        this.checkUseSnmpTraps = new Button(clientArea, 32);
        Messages.get();
        this.checkUseSnmpTraps.setText(Messages.NetworkDiscoveryConfigurator_UseSNMPTrapsForDiscovery);
        this.checkUseSnmpTraps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.config.setUseSnmpTraps(NetworkDiscoveryConfigurator.this.checkUseSnmpTraps.getSelection());
                NetworkDiscoveryConfigurator.this.setModified();
            }
        });
        gd = new GridData();
        gd.verticalIndent = 10;
        this.checkUseSnmpTraps.setLayoutData((Object)gd);
        this.checkUseSyslog = new Button(clientArea, 32);
        Messages.get();
        this.checkUseSyslog.setText(Messages.NetworkDiscoveryConfigurator_UseSyslogForDiscovery);
        this.checkUseSyslog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.config.setUseSyslog(NetworkDiscoveryConfigurator.this.checkUseSyslog.getSelection());
                NetworkDiscoveryConfigurator.this.setModified();
            }
        });
    }

    private void enablePassiveDiscovery(boolean enabled) {
        this.passiveDiscoveryInterval.setEnabled(enabled);
    }

    private void enableActiveDiscovery(boolean enabled) {
        if (this.radioActiveDiscoveryInterval.getSelection()) {
            this.activeDiscoverySchedule.setEnabled(false);
        } else {
            this.activeDiscoveryInterval.setEnabled(false);
        }
        this.radioActiveDiscoveryInterval.setEnabled(enabled);
        this.radioActiveDiscoverySchedule.setEnabled(enabled);
    }

    private void createScheduleSection() {
        Section section = new Section(this.content, "Schedule", false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.passiveDiscoveryInterval = WidgetHelper.createLabeledSpinner((Composite)clientArea, (int)2048, (String)"Passive discovery interval", (int)0, (int)0xFFFFFF, (Object)gd);
        this.passiveDiscoveryInterval.setBackground(clientArea.getBackground());
        this.passiveDiscoveryInterval.getParent().setBackground(clientArea.getBackground());
        this.passiveDiscoveryInterval.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    NetworkDiscoveryConfigurator.this.config.setPassiveDiscoveryPollInterval(Integer.parseInt(NetworkDiscoveryConfigurator.this.passiveDiscoveryInterval.getText()));
                    NetworkDiscoveryConfigurator.this.setModified();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.activeDiscoveryScheduleLabel = new Label(clientArea, 16384);
        this.activeDiscoveryScheduleLabel.setText("Active discovery schedule configuration");
        this.activeDiscoveryScheduleLabel.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.activeDiscoveryScheduleLabel.setLayoutData((Object)gd);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.setModified();
                if (NetworkDiscoveryConfigurator.this.radioActiveDiscoveryInterval.getSelection()) {
                    NetworkDiscoveryConfigurator.this.config.setActiveDiscoveryPollInterval(Integer.parseInt(NetworkDiscoveryConfigurator.this.activeDiscoveryInterval.getText()));
                    NetworkDiscoveryConfigurator.this.activeDiscoveryInterval.setSelection(NetworkDiscoveryConfigurator.this.config.getActiveDiscoveryPollInterval() == 0 ? 7200 : NetworkDiscoveryConfigurator.this.config.getActiveDiscoveryPollInterval());
                    NetworkDiscoveryConfigurator.this.activeDiscoverySchedule.setEnabled(false);
                    NetworkDiscoveryConfigurator.this.activeDiscoveryInterval.setEnabled(true);
                } else {
                    NetworkDiscoveryConfigurator.this.config.setActiveDiscoveryPollInterval(0);
                    NetworkDiscoveryConfigurator.this.activeDiscoverySchedule.setText(NetworkDiscoveryConfigurator.this.config.getActiveDiscoveryPollSchedule());
                    NetworkDiscoveryConfigurator.this.activeDiscoverySchedule.setEnabled(true);
                    NetworkDiscoveryConfigurator.this.activeDiscoveryInterval.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioActiveDiscoveryInterval = new Button(clientArea, 16);
        this.radioActiveDiscoveryInterval.setText("Interval");
        this.radioActiveDiscoveryInterval.addSelectionListener(listener);
        gd = new GridData();
        this.radioActiveDiscoveryInterval.setLayoutData((Object)gd);
        this.radioActiveDiscoverySchedule = new Button(clientArea, 16);
        this.radioActiveDiscoverySchedule.setText("Schedule");
        this.radioActiveDiscoverySchedule.addSelectionListener(listener);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 16384;
        this.radioActiveDiscoverySchedule.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.activeDiscoveryInterval = WidgetHelper.createLabeledSpinner((Composite)clientArea, (int)2048, (String)"Active discovery interval", (int)0, (int)0xFFFFFF, (Object)gd);
        this.activeDiscoveryInterval.setBackground(clientArea.getBackground());
        this.activeDiscoveryInterval.getParent().setBackground(clientArea.getBackground());
        this.activeDiscoveryInterval.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NetworkDiscoveryConfigurator.this.config.setActiveDiscoveryPollInterval(Integer.parseInt(NetworkDiscoveryConfigurator.this.activeDiscoveryInterval.getText()));
                NetworkDiscoveryConfigurator.this.setModified();
            }
        });
        this.activeDiscoverySchedule = new LabeledText(clientArea, 0, 2052);
        this.activeDiscoverySchedule.setLabel("Active discovery schedule");
        this.activeDiscoverySchedule.setBackground(clientArea.getBackground());
        this.activeDiscoverySchedule.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NetworkDiscoveryConfigurator.this.config.setActiveDiscoveryPollSchedule(NetworkDiscoveryConfigurator.this.activeDiscoverySchedule.getText());
                NetworkDiscoveryConfigurator.this.setModified();
            }
        });
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 16384;
        this.activeDiscoverySchedule.setLayoutData((Object)gd);
    }

    private void createFilterSection() {
        Messages.get();
        Section section = new Section(this.content, Messages.NetworkDiscoveryConfigurator_SectionFilter, false);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 3;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        SelectionAdapter checkBoxListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkDiscoveryConfigurator.this.setModified();
                int flags = 0;
                if (NetworkDiscoveryConfigurator.this.checkFilterRange.getSelection()) {
                    flags |= 2;
                }
                if (NetworkDiscoveryConfigurator.this.checkFilterScript.getSelection()) {
                    flags |= 4;
                }
                if (NetworkDiscoveryConfigurator.this.checkFilterProtocols.getSelection()) {
                    flags |= 1;
                }
                if (NetworkDiscoveryConfigurator.this.checkAllowAgent.getSelection()) {
                    flags |= 0x100;
                }
                if (NetworkDiscoveryConfigurator.this.checkAllowSNMP.getSelection()) {
                    flags |= 0x200;
                }
                if (NetworkDiscoveryConfigurator.this.checkAllowSSH.getSelection()) {
                    flags |= 0x400;
                }
                NetworkDiscoveryConfigurator.this.config.setFilterFlags(flags);
            }
        };
        this.checkFilterRange = new Button(clientArea, 32);
        this.checkFilterRange.setText("By address range");
        this.checkFilterRange.addSelectionListener((SelectionListener)checkBoxListener);
        Composite addressRangeEditor = new Composite(clientArea, 0);
        addressRangeEditor.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.horizontalIndent = 20;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        addressRangeEditor.setLayoutData((Object)gd);
        GridLayout addressRangeLayout = new GridLayout();
        addressRangeLayout.numColumns = 2;
        addressRangeEditor.setLayout((Layout)addressRangeLayout);
        String[] names = new String[]{"Range", "Comment"};
        int[] widths = new int[]{150, 150};
        this.filterAddressList = new SortableTableViewer(addressRangeEditor, names, widths, 0, 1024, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.heightHint = 200;
        this.filterAddressList.getTable().setLayoutData((Object)gd);
        this.filterAddressList.getTable().setSortDirection(128);
        this.filterAddressList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filterAddressList.setLabelProvider((IBaseLabelProvider)new AddressListLabelProvider(false));
        this.filterAddressList.setComparator((ViewerComparator)new AddressListElementComparator(false));
        this.filterAddressList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NetworkDiscoveryConfigurator.this.editAddressFilterElement();
            }
        });
        ImageHyperlink linkAdd = new ImageHyperlink(addressRangeEditor, 0);
        Messages.get();
        linkAdd.setText(Messages.NetworkDiscoveryConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.addAddressFilterElement();
            }
        });
        final ImageHyperlink linkEdit = new ImageHyperlink(addressRangeEditor, 0);
        linkEdit.setText("Edit...");
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        linkEdit.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.editAddressFilterElement();
            }
        });
        final ImageHyperlink linkRemove = new ImageHyperlink(addressRangeEditor, 0);
        Messages.get();
        linkRemove.setText(Messages.NetworkDiscoveryConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        linkRemove.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.removeAddressFilterElements();
            }
        });
        this.filterAddressList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = NetworkDiscoveryConfigurator.this.filterAddressList.getStructuredSelection();
                linkEdit.setEnabled(selection.size() == 1);
                linkRemove.setEnabled(!selection.isEmpty());
            }
        });
        this.checkFilterProtocols = new Button(clientArea, 32);
        this.checkFilterProtocols.setText("By communication protocols");
        this.checkFilterProtocols.addSelectionListener((SelectionListener)checkBoxListener);
        this.checkAllowAgent = new Button(clientArea, 32);
        Messages.get();
        this.checkAllowAgent.setText(Messages.NetworkDiscoveryConfigurator_AcceptAgent);
        this.checkAllowAgent.addSelectionListener((SelectionListener)checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkAllowAgent.setLayoutData((Object)gd);
        this.checkAllowSNMP = new Button(clientArea, 32);
        Messages.get();
        this.checkAllowSNMP.setText(Messages.NetworkDiscoveryConfigurator_AcceptSNMP);
        this.checkAllowSNMP.addSelectionListener((SelectionListener)checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkAllowSNMP.setLayoutData((Object)gd);
        this.checkAllowSSH = new Button(clientArea, 32);
        this.checkAllowSSH.setText("Accept node if it is accessible via SS&H");
        this.checkAllowSSH.addSelectionListener((SelectionListener)checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkAllowSSH.setLayoutData((Object)gd);
        this.checkFilterScript = new Button(clientArea, 32);
        this.checkFilterScript.setText("With custom script");
        this.checkFilterScript.addSelectionListener((SelectionListener)checkBoxListener);
        this.filterScript = new ScriptSelector(clientArea, 0, true, false);
        this.filterScript.setBackground(clientArea.getBackground());
        this.filterScript.getTextControl().setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NetworkDiscoveryConfigurator.this.config.setFilterScript(NetworkDiscoveryConfigurator.this.filterScript.getScriptName());
                NetworkDiscoveryConfigurator.this.setModified();
            }
        });
    }

    private void createActiveDiscoverySection() {
        Messages.get();
        Section section = new Section(this.content, Messages.NetworkDiscoveryConfigurator_SectionActiveDiscoveryTargets, false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        String[] names = new String[]{"Range", "Proxy", "Comments"};
        int[] widths = new int[]{150, 150, 150};
        this.activeDiscoveryAddressList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.activeDiscoveryAddressList.getTable().setLayoutData((Object)gd);
        this.activeDiscoveryAddressList.getTable().setSortDirection(128);
        this.activeDiscoveryAddressList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.activeDiscoveryAddressList.setLabelProvider((IBaseLabelProvider)new AddressListLabelProvider(true));
        this.activeDiscoveryAddressList.setComparator((ViewerComparator)new AddressListElementComparator(true));
        this.activeDiscoveryAddressList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NetworkDiscoveryConfigurator.this.editTargetAddressListElement();
            }
        });
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkAdd.setText(Messages.NetworkDiscoveryConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.addTargetAddressListElement();
            }
        });
        final ImageHyperlink linkEdit = new ImageHyperlink(controlArea, 0);
        linkEdit.setText("Edit...");
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        linkEdit.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.editTargetAddressListElement();
            }
        });
        final ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkRemove.setText(Messages.NetworkDiscoveryConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        linkRemove.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.removeTargetAddressListElements();
            }
        });
        final ImageHyperlink runActiveDiscovery = new ImageHyperlink(controlArea, 0);
        runActiveDiscovery.setText("Scan");
        runActiveDiscovery.setToolTipText("Runs active discovery on selected ranges");
        runActiveDiscovery.setImage(SharedIcons.IMG_EXECUTE);
        runActiveDiscovery.setBackground(clientArea.getBackground());
        runActiveDiscovery.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        runActiveDiscovery.setLayoutData((Object)gd);
        runActiveDiscovery.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkDiscoveryConfigurator.this.scanAddressRange();
            }
        });
        this.activeDiscoveryAddressList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = NetworkDiscoveryConfigurator.this.activeDiscoveryAddressList.getStructuredSelection();
                linkEdit.setEnabled(selection.size() == 1);
                linkRemove.setEnabled(!selection.isEmpty());
                runActiveDiscovery.setEnabled(!selection.isEmpty());
            }
        });
    }

    public void setFocus() {
        this.content.setFocus();
    }

    public void setConfig(NetworkDiscoveryConfig config) {
        this.config = config;
        this.radioDiscoveryOff.setSelection(config.getDiscoveryType() == 0);
        this.radioDiscoveryPassive.setSelection(config.getDiscoveryType() == 1);
        this.radioDiscoveryActive.setSelection(config.getDiscoveryType() == 2);
        this.radioDiscoveryActiveAndPassive.setSelection(config.getDiscoveryType() == 3);
        this.checkUseSnmpTraps.setSelection(config.isUseSnmpTraps());
        this.checkUseSyslog.setSelection(config.isUseSyslog());
        this.passiveDiscoveryInterval.setSelection(config.getPassiveDiscoveryPollInterval());
        if (config.getActiveDiscoveryPollInterval() != 0) {
            this.radioActiveDiscoveryInterval.setSelection(true);
        } else {
            this.radioActiveDiscoverySchedule.setSelection(true);
        }
        this.activeDiscoveryInterval.setSelection(config.getActiveDiscoveryPollInterval());
        this.activeDiscoverySchedule.setText(config.getActiveDiscoveryPollSchedule());
        this.enableActiveDiscovery(config.getDiscoveryType() == 2 || config.getDiscoveryType() == 3);
        this.enablePassiveDiscovery(config.getDiscoveryType() == 1 || config.getDiscoveryType() == 3);
        this.checkFilterRange.setSelection((config.getFilterFlags() & 2) != 0);
        this.checkFilterScript.setSelection((config.getFilterFlags() & 4) != 0);
        this.checkFilterProtocols.setSelection((config.getFilterFlags() & 1) != 0);
        this.checkAllowAgent.setSelection((config.getFilterFlags() & 0x100) != 0);
        this.checkAllowSNMP.setSelection((config.getFilterFlags() & 0x200) != 0);
        this.checkAllowSSH.setSelection((config.getFilterFlags() & 0x400) != 0);
        this.activeDiscoveryAddressList.setInput((Object)config.getTargets().toArray());
        this.filterAddressList.setInput((Object)config.getAddressFilter().toArray());
        this.filterScript.setScriptName(config.getFilterScript());
        this.modified = false;
        this.firePropertyChange(257);
    }

    private void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.config.save();
        }
        catch (Exception e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.NetworkDiscoveryConfigurator_Error, (String)String.format(Messages.NetworkDiscoveryConfigurator_SaveErrorText, e.getLocalizedMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void save() {
        Messages.get();
        new ConsoleJob(Messages.NetworkDiscoveryConfigurator_SaveJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NetworkDiscoveryConfigurator.this.config.save();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).NetworkDiscoveryConfigurator.this.modified = false;
                        NetworkDiscoveryConfigurator.this.firePropertyChange(257);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkDiscoveryConfigurator_SaveJobError;
            }
        }.start();
    }

    private void addTargetAddressListElement() {
        InetAddressListElement element;
        List<InetAddressListElement> list;
        AddAddressListElementDialog dlg = new AddAddressListElementDialog(this.getSite().getShell(), true, null);
        if (dlg.open() == 0 && !(list = this.config.getTargets()).contains(element = dlg.getElement())) {
            list.add(element);
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void editTargetAddressListElement() {
        IStructuredSelection selection = (IStructuredSelection)this.activeDiscoveryAddressList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AddAddressListElementDialog dlg = new AddAddressListElementDialog(this.getSite().getShell(), true, (InetAddressListElement)selection.getFirstElement());
        if (dlg.open() == 0) {
            List<InetAddressListElement> list = this.config.getTargets();
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void removeTargetAddressListElements() {
        List<InetAddressListElement> list = this.config.getTargets();
        IStructuredSelection selection = (IStructuredSelection)this.activeDiscoveryAddressList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void scanAddressRange() {
        IStructuredSelection selection = this.activeDiscoveryAddressList.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getSite().getShell(), (String)"Active discovery", (String)"Are you sure you want to start manual scan for selected ranges?")) {
            return;
        }
        final ArrayList<InetAddressListElement> list = new ArrayList<InetAddressListElement>();
        for (Object o : selection.toList()) {
            list.add((InetAddressListElement)o);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Run active discovery poll", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.startManualActiveDiscovery(list);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder sb = new StringBuilder("Active discovery started for ranges:\n");
                        int i = 0;
                        while (i < list.size()) {
                            InetAddressListElement e = (InetAddressListElement)list.get(i);
                            sb.append(e.getType() == 0 ? String.valueOf(e.getBaseAddress().getHostAddress()) + "/" + e.getMaskBits() : String.valueOf(e.getBaseAddress().getHostAddress()) + " - " + e.getEndAddress().getHostAddress());
                            if (i + 1 != list.size()) {
                                sb.append("\n");
                            }
                            ++i;
                        }
                        MessageDialogHelper.openInformation((Shell)NetworkDiscoveryConfigurator.this.getSite().getShell(), (String)"Active discovery started", (String)sb.toString());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error startin active discovery";
            }
        }.start();
    }

    private void addAddressFilterElement() {
        InetAddressListElement element;
        List<InetAddressListElement> list;
        AddAddressListElementDialog dlg = new AddAddressListElementDialog(this.getSite().getShell(), false, null);
        if (dlg.open() == 0 && !(list = this.config.getAddressFilter()).contains(element = dlg.getElement())) {
            list.add(element);
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void editAddressFilterElement() {
        IStructuredSelection selection = this.filterAddressList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AddAddressListElementDialog dlg = new AddAddressListElementDialog(this.getSite().getShell(), false, (InetAddressListElement)selection.getFirstElement());
        if (dlg.open() == 0) {
            List<InetAddressListElement> list = this.config.getAddressFilter();
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void removeAddressFilterElements() {
        List<InetAddressListElement> list = this.config.getAddressFilter();
        IStructuredSelection selection = (IStructuredSelection)this.filterAddressList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }
}

