/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.ui.eclipse.datacollection.dialogs.DataSourceEditDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectDciDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.propertypages.helpers.DciListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DataSources
extends PreferencePage {
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_METRIC = 2;
    public static final int COLUMN_LABEL = 3;
    public static final int COLUMN_COLOR = 4;
    private GraphDefinition config;
    private DciListLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<ChartDciConfig> dciList = null;
    private ColorCache colorCache;
    private boolean graphIsTemplate = false;
    private boolean saveToDatabase;

    public DataSources(GraphDefinition settings, boolean saveToDatabase) {
        super("Data Source");
        this.config = settings;
        this.saveToDatabase = saveToDatabase;
    }

    protected Control createContents(Composite parent) {
        this.graphIsTemplate = this.config.isTemplate();
        Composite dialogArea = new Composite(parent, 0);
        this.colorCache = new ColorCache((Control)dialogArea);
        this.dciList = new ArrayList<ChartDciConfig>();
        ChartDciConfig[] chartDciConfigArray = this.config.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            this.dciList.add(new ChartDciConfig(dci));
            ++n2;
        }
        this.labelProvider = new DciListLabelProvider(this.dciList);
        this.labelProvider.resolveDciNames(this.dciList);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.DataSources_ColPosition;
        Messages.get();
        stringArray[1] = Messages.DataSources_ColNode;
        Messages.get();
        stringArray[2] = Messages.DataSources_ColParameter;
        Messages.get();
        stringArray[3] = Messages.DataSources_ColLabel;
        Messages.get();
        stringArray[4] = Messages.DataSources_ColColor;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{40, 130, 200, 150, 50};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 4) {
                    DataSources.this.drawColorCell(event);
                }
            }
        });
        this.viewer.setInput((Object)this.dciList.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.DataSources_Up);
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DataSources.this.moveUp();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.DataSources_Down);
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DataSources.this.moveDown();
            }
        });
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        Messages.get();
        this.addButton.setText(Messages.DataSources_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DataSources.this.addItem();
            }
        });
        this.editButton = new Button(rightButtons, 8);
        Messages.get();
        this.editButton.setText(Messages.DataSources_Modify);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DataSources.this.editItem();
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.DataSources_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DataSources.this.deleteItems();
            }
        });
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DataSources.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DataSources.this.viewer.getSelection();
                DataSources.this.editButton.setEnabled(selection.size() == 1);
                DataSources.this.deleteButton.setEnabled(selection.size() > 0);
                DataSources.this.upButton.setEnabled(selection.size() == 1);
                DataSources.this.downButton.setEnabled(selection.size() == 1);
            }
        });
        return dialogArea;
    }

    private void drawColorCell(Event event) {
        TableItem item = (TableItem)event.item;
        ChartDciConfig dci = (ChartDciConfig)item.getData();
        if (dci.color.equalsIgnoreCase("UNSET")) {
            return;
        }
        int width = this.viewer.getTable().getColumn(4).getWidth();
        Color color = ColorConverter.colorFromInt((int)dci.getColorAsInt(), (ColorCache)this.colorCache);
        event.gc.setForeground(this.colorCache.create(0, 0, 0));
        event.gc.setBackground(color);
        event.gc.setLineWidth(1);
        event.gc.fillRectangle(event.x + 3, event.y + 2, width - 7, event.height - 5);
        event.gc.drawRectangle(event.x + 3, event.y + 2, width - 7, event.height - 5);
    }

    private void addItem() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), 0L);
        if (dlg.open() == 0) {
            List selection = dlg.getSelection();
            ArrayList<ChartDciConfig> select = new ArrayList<ChartDciConfig>();
            for (DciValue item : selection) {
                ChartDciConfig dci = new ChartDciConfig(item);
                this.labelProvider.addCacheEntry(dci.nodeId, dci.dciId, dci.name);
                select.add(dci);
                this.dciList.add(dci);
            }
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(select));
        }
    }

    private void editItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        ChartDciConfig dci = (ChartDciConfig)selection.getFirstElement();
        if (dci == null) {
            return;
        }
        DataSourceEditDlg dlg = new DataSourceEditDlg(this.getShell(), dci, this.graphIsTemplate);
        if (dlg.open() == 0) {
            this.viewer.update((Object)dci, null);
        }
    }

    private void deleteItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.dciList.remove(o);
        }
        this.viewer.setInput((Object)this.dciList.toArray());
    }

    private void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.dciList, index - 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) < this.dciList.size() - 1 && index >= 0) {
            Collections.swap(this.dciList, index + 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void applyChanges(boolean isApply) {
        if (!this.isControlCreated()) {
            return;
        }
        this.config.setDciList(this.dciList.toArray(new ChartDciConfig[this.dciList.size()]));
        if (this.saveToDatabase && isApply) {
            this.setValid(false);
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.DataSources_JobName, null, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.saveGraph(DataSources.this.config, false);
                }

                protected void jobFinalize() {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            DataSources.this.setValid(true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.DataSources_JobError;
                }
            }.start();
        }
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

