/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class InterfacePolling
extends PropertyPage {
    private Spinner pollCount;
    private Combo expectedState;
    private Interface object;
    private int currentPollCount;
    private int currentExpectedState;
    private int currentFlags;
    private List<Button> flagButtons = new ArrayList<Button>();
    private List<Integer> flagValues = new ArrayList<Integer>();

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Interface)this.getElement().getAdapter(Interface.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.pollCount = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.InterfacePolling_RequiredPollCount, (int)0, (int)1000, (Object)"WidgetHelper::default_layout_data");
        this.pollCount.setSelection(this.object.getRequiredPollCount());
        Messages.get();
        this.expectedState = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.InterfacePolling_ExpectedState, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.expectedState.add(Messages.InterfacePolling_StateUP);
        Messages.get();
        this.expectedState.add(Messages.InterfacePolling_StateDOWN);
        Messages.get();
        this.expectedState.add(Messages.InterfacePolling_StateIGNORE);
        this.expectedState.select(this.object.getExpectedState());
        Messages.get();
        this.addFlag(dialogArea, 4, Messages.InterfacePolling_ExcludeFromTopology);
        this.addFlag(dialogArea, 64, "&Collect ICMP response statistic for this interface");
        this.addFlag(dialogArea, 512, "Disable status polling with NetXMS &agent");
        this.addFlag(dialogArea, 128, "Disable status polling with &SNMP");
        this.addFlag(dialogArea, 256, "Disable status polling with &ICMP");
        this.currentPollCount = this.object.getRequiredPollCount();
        this.currentExpectedState = this.object.getExpectedState();
        this.currentFlags = this.object.getFlags() & this.collectFlagsMask();
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        int flags = this.collectFlags();
        int flagMask = this.collectFlagsMask();
        if (this.expectedState.getSelectionIndex() == this.currentExpectedState && this.pollCount.getSelection() == this.currentPollCount && flags == this.currentFlags) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData data = new NXCObjectModificationData(this.object.getObjectId());
        data.setExpectedState(this.expectedState.getSelectionIndex());
        data.setRequiredPolls(this.pollCount.getSelection());
        data.setObjectFlags(flags, flagMask);
        Messages.get();
        new ConsoleJob(Messages.InterfacePolling_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(data);
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.InterfacePolling_JobError, InterfacePolling.this.object.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).InterfacePolling.this.currentExpectedState = data.getExpectedState();
                            (this).InterfacePolling.this.currentPollCount = data.getRequiredPolls();
                            (this).InterfacePolling.this.currentFlags = InterfacePolling.this.collectFlags();
                            InterfacePolling.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    private void addFlag(Composite parent, int value, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        button.setSelection((this.object.getFlags() & value) != 0);
        this.flagButtons.add(button);
        this.flagValues.add(value);
    }

    private int collectFlags() {
        int flags = this.object.getFlags();
        int i = 0;
        while (i < this.flagButtons.size()) {
            flags = this.flagButtons.get(i).getSelection() ? (flags |= this.flagValues.get(i).intValue()) : (flags &= ~this.flagValues.get(i).intValue());
            ++i;
        }
        return flags;
    }

    private int collectFlagsMask() {
        int mask = 0;
        int i = 0;
        while (i < this.flagButtons.size()) {
            mask |= this.flagValues.get(i).intValue();
            ++i;
        }
        return mask;
    }
}

