/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.widgets.EventTemplateList;

public class EventSelectionDialog
extends Dialog {
    private static final String CONFIG_PREFIX = "SelectEvent";
    private boolean multiSelection;
    private EventTemplate[] selectedEvents;
    private EventTemplateList eventTemplateList;

    public EventSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.multiSelection = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.EventSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectEvent.cx"), settings.getInt("SelectEvent.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FormLayout());
        this.eventTemplateList = new EventTemplateList(dialogArea, 0, CONFIG_PREFIX, true);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.eventTemplateList.setLayoutData(fd);
        this.eventTemplateList.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EventSelectionDialog.this.okPressed();
            }
        });
        this.eventTemplateList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Point size = EventSelectionDialog.this.getShell().getSize();
                IDialogSettings settings = Activator.getDefault().getDialogSettings();
                settings.put("SelectEvent.cx", size.x);
                settings.put("SelectEvent.cy", size.y);
            }
        });
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.eventTemplateList.getViewer().getSelection();
        List list = selection.toList();
        this.selectedEvents = list.toArray(new EventTemplate[list.size()]);
        super.okPressed();
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public EventTemplate[] getSelectedEvents() {
        return this.selectedEvents;
    }
}

