/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.lang.reflect.InvocationTargetException;
import java.security.Signature;
import java.security.cert.Certificate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.certificate.loader.KeyStoreRequestListener;
import org.netxms.certificate.manager.CertificateManager;
import org.netxms.certificate.manager.CertificateManagerProvider;
import org.netxms.certificate.request.KeyStoreEntryPasswordRequestListener;
import org.netxms.client.LicenseProblem;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectFilter;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.ApplicationActionBarAdvisor;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.ServerNameStatusLineItem;
import org.netxms.ui.eclipse.console.SplashHandler;
import org.netxms.ui.eclipse.console.StatusLineContributionItem;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.console.dialogs.LoginDialog;
import org.netxms.ui.eclipse.console.dialogs.PasswordExpiredDialog;
import org.netxms.ui.eclipse.console.dialogs.PasswordRequestDialog;
import org.netxms.ui.eclipse.console.dialogs.SecurityWarningDialog;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.jobs.LoginJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.Command;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor
implements KeyStoreRequestListener,
KeyStoreEntryPasswordRequestListener {
    private IDialogSettings settings;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        this.doLogin(Display.getCurrent());
        RegionalSettings.updateFromPreferences();
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(ps.getBoolean("SHOW_COOLBAR"));
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(!ConsoleSharedData.getSession().getClientConfigurationHintAsBoolean("PerspectiveSwitcher.Enable", true));
        TweakletManager.preWindowOpen(configurer);
    }

    public void postWindowCreate() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setTitle(String.valueOf(configurer.getTitle()) + " - [" + this.settings.get("Connect.Login") + "@" + this.settings.get("Connect.Server") + "]");
        NXCSession session = ConsoleSharedData.getSession();
        final Activator activator = Activator.getDefault();
        StatusLineContributionItem statusItemConnection = (StatusLineContributionItem)activator.getStatusLine().find("ConnectionStatus");
        statusItemConnection.setImage(Activator.getImageDescriptor(session.isEncrypted() ? "icons/conn_encrypted.png" : "icons/conn_unencrypted.png").createImage());
        statusItemConnection.setText(String.valueOf(session.getUserName()) + "@" + session.getServerAddress() + " (" + session.getServerVersion() + ")");
        ServerNameStatusLineItem statusItemServerName = (ServerNameStatusLineItem)activator.getStatusLine().find("ServerName");
        statusItemServerName.setServerInfo(session.getServerName(), session.getServerColor());
        if (activator.getPreferenceStore().getBoolean("SHOW_TRAY_ICON")) {
            Activator.showTrayIcon();
        }
        session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1038: {
                        activator.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                StatusLineContributionItem objecSyncStatus = (StatusLineContributionItem)activator.getStatusLine().find("ObjectSyncStatus");
                                objecSyncStatus.setText("Objects are out of sync");
                            }
                        });
                        break;
                    }
                    case 1052: {
                        activator.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                StatusLineContributionItem objecSyncStatus = (StatusLineContributionItem)activator.getStatusLine().find("ObjectSyncStatus");
                                objecSyncStatus.setText("");
                            }
                        });
                    }
                }
            }
        });
        TweakletManager.postWindowCreate(configurer);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        boolean exitAfterOpen = false;
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals("-fullscreen")) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setFullScreen(true);
                Action a = (Action)ConsoleSharedData.getProperty("FullScreenAction");
                if (a != null) {
                    a.setChecked(true);
                }
            } else if (s.startsWith("-dashboard=")) {
                this.showDashboard(s.substring(11), false);
            } else if (s.startsWith("-exit-after-open")) {
                exitAfterOpen = true;
            } else if (s.startsWith("-fullscreen-dashboard=")) {
                this.showDashboard(s.substring(22), true);
            } else if (s.startsWith("-take-map-snapshot=")) {
                this.takeMapSnapshot(s.substring(19));
            }
            ++n2;
        }
        if (exitAfterOpen) {
            new UIJob("Exit console"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    PlatformUI.getWorkbench().close();
                    return Status.OK_STATUS;
                }
            }.schedule(1000L);
        } else {
            this.showMessageOfTheDay();
        }
    }

    private void takeMapSnapshot(String param) {
        long objectId;
        final String[] parts = param.split(",");
        if (parts.length != 2) {
            return;
        }
        NXCSession session = ConsoleSharedData.getSession();
        try {
            objectId = Long.parseLong(parts[0]);
        }
        catch (NumberFormatException e) {
            AbstractObject object = session.findObjectByName(parts[0], new ObjectFilter(){

                public boolean filter(AbstractObject object) {
                    return object instanceof NetworkMap;
                }
            });
            if (object == null || !(object instanceof NetworkMap)) {
                Messages.get();
                MessageDialogHelper.openError(null, Messages.ApplicationWorkbenchWindowAdvisor_Error, String.format("Cannot open network map %s", parts[0]));
                return;
            }
            objectId = object.getObjectId();
        }
        final IWorkbenchPage page = this.getWindowConfigurer().getWindow().getActivePage();
        try {
            final IViewPart view = page.showView("org.netxms.ui.eclipse.networkmaps.views.PredefinedMap", Long.toString(objectId), 1);
            page.setPartState(page.getReference((IWorkbenchPart)view), 1);
            new UIJob("Save map to file"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ((Command)view).execute("AbstractNetworkMap/SaveToFile", parts[1]);
                    page.setPartState(page.getReference((IWorkbenchPart)view), 2);
                    page.hideView(view);
                    return Status.OK_STATUS;
                }
            }.schedule(600L);
        }
        catch (PartInitException e) {
            Messages.get();
            MessageDialogHelper.openError(null, Messages.ApplicationWorkbenchWindowAdvisor_Error, String.format("Cannot open network map view %s (%s)", parts[0], e.getLocalizedMessage()));
        }
    }

    private void showDashboard(String dashboardId, boolean fullScreen) {
        long objectId;
        NXCSession session = ConsoleSharedData.getSession();
        try {
            objectId = Long.parseLong(dashboardId);
        }
        catch (NumberFormatException e) {
            AbstractObject object = session.findObjectByName(dashboardId, new ObjectFilter(){

                public boolean filter(AbstractObject object) {
                    return object instanceof Dashboard;
                }
            });
            if (object == null || !(object instanceof Dashboard)) {
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError(null, Messages.ApplicationWorkbenchWindowAdvisor_Error, String.format(Messages.ApplicationWorkbenchWindowAdvisor_CannotOpenDashboard, dashboardId));
                return;
            }
            objectId = object.getObjectId();
        }
        Dashboard dashboard = (Dashboard)session.findObjectById(objectId, Dashboard.class);
        if (dashboard == null) {
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError(null, Messages.ApplicationWorkbenchWindowAdvisor_Error, String.format(Messages.ApplicationWorkbenchWindowAdvisor_CannotOpenDashboard, dashboardId));
            return;
        }
        IWorkbenchPage page = this.getWindowConfigurer().getWindow().getActivePage();
        try {
            IViewPart view = page.showView("org.netxms.ui.eclipse.dashboard.views.DashboardView", Long.toString(objectId), 1);
            if (fullScreen) {
                ((ViewPart)view).setPartProperty("FullScreen", "true");
            } else {
                page.setPartState(page.getReference((IWorkbenchPart)view), 1);
            }
        }
        catch (PartInitException e) {
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError(null, Messages.ApplicationWorkbenchWindowAdvisor_Error, String.format(Messages.ApplicationWorkbenchWindowAdvisor_CannotOpenDashboardType2, dashboardId, e.getLocalizedMessage()));
        }
    }

    private void doLogin(Display display) {
        this.settings = Activator.getDefault().getDialogSettings();
        boolean success = false;
        boolean autoConnect = false;
        boolean ignoreProtocolVersion = false;
        String password = "";
        CertificateManager certMgr = CertificateManagerProvider.provideCertificateManager();
        certMgr.setKeyStoreRequestListener((KeyStoreRequestListener)this);
        certMgr.setPasswordRequestListener((KeyStoreEntryPasswordRequestListener)this);
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-server=")) {
                this.settings.put("Connect.Server", s.substring(8));
            } else if (s.startsWith("-login=")) {
                this.settings.put("Connect.Login", s.substring(7));
            } else if (s.startsWith("-password=")) {
                password = s.substring(10);
                this.settings.put("Connect.AuthMethod", AuthenticationType.PASSWORD.getValue());
            } else if (s.equals("-auto")) {
                autoConnect = true;
            } else if (s.equals("-ignore-protocol-version")) {
                ignoreProtocolVersion = true;
            }
            ++n2;
        }
        boolean encrypt = true;
        LoginDialog loginDialog = new LoginDialog(null, certMgr);
        while (!success) {
            AuthenticationType authMethod;
            if (!autoConnect) {
                if (loginDialog.open() != 0) {
                    System.exit(0);
                }
                password = loginDialog.getPassword();
            } else {
                autoConnect = false;
            }
            ConsoleSharedData.setProperty("SlowLink", this.settings.getBoolean("Connect.SlowLink"));
            LoginJob job = new LoginJob(display, this.settings.get("Connect.Server"), this.settings.get("Connect.Login"), encrypt, ignoreProtocolVersion);
            try {
                authMethod = AuthenticationType.getByValue((int)this.settings.getInt("Connect.AuthMethod"));
            }
            catch (NumberFormatException e) {
                authMethod = AuthenticationType.PASSWORD;
            }
            switch (authMethod) {
                case PASSWORD: {
                    job.setPassword(password);
                    break;
                }
                case CERTIFICATE: {
                    job.setCertificate(loginDialog.getCertificate(), ApplicationWorkbenchWindowAdvisor.getSignature(certMgr, loginDialog.getCertificate()));
                    break;
                }
            }
            try {
                ModalContext.run((IRunnableWithProgress)job, (boolean)true, (IProgressMonitor)SplashHandler.getInstance().getBundleProgressMonitor(), (Display)Display.getCurrent());
                success = true;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NXCException && (((NXCException)e.getCause()).getErrorCode() == 45 || ((NXCException)e.getCause()).getErrorCode() == 42) && encrypt) {
                    boolean alwaysAllow = this.settings.getBoolean("Connect.AllowUnencrypted." + this.settings.get("Connect.Server"));
                    int action = this.getAction(this.settings, alwaysAllow);
                    if (action == 0) continue;
                    autoConnect = true;
                    encrypt = false;
                    if (action != 2) continue;
                    this.settings.put("Connect.AllowUnencrypted." + this.settings.get("Connect.Server"), true);
                    continue;
                }
                e.getCause().printStackTrace();
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_ConnectionError, (String)e.getCause().getLocalizedMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Exception, (String)e.toString());
            }
        }
        CertificateManagerProvider.dispose();
        NXCSession session = ConsoleSharedData.getSession();
        if (session.getAuthenticationMethod() == AuthenticationType.PASSWORD && session.isPasswordExpired()) {
            this.requestPasswordChange(loginDialog.getPassword(), session);
        }
    }

    private static Signature getSignature(CertificateManager certMgr, Certificate cert) {
        Signature sign;
        try {
            sign = certMgr.extractSignature(cert);
        }
        catch (Exception e) {
            Activator.logError("Exception in getSignature", e);
            return null;
        }
        return sign;
    }

    private int getAction(IDialogSettings settings, boolean alwaysAllow) {
        if (alwaysAllow) {
            return 1;
        }
        Messages.get();
        String string = String.format(Messages.ApplicationWorkbenchWindowAdvisor_NoEncryptionSupport, settings.get("Connect.Server"));
        Messages.get();
        return SecurityWarningDialog.showSecurityWarning(null, string, Messages.ApplicationWorkbenchWindowAdvisor_NoEncryptionSupportDetails);
    }

    private void requestPasswordChange(final String currentPassword, final NXCSession session) {
        final PasswordExpiredDialog dlg = new PasswordExpiredDialog(null, session.getGraceLogins());
        while (dlg.open() == 0) {
            IRunnableWithProgress job = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            Messages.get();
                            monitor.setTaskName(Messages.ApplicationWorkbenchWindowAdvisor_ChangingPassword);
                            session.setUserPassword((long)session.getUserId(), dlg.getPassword(), currentPassword);
                            monitor.setTaskName("");
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                ModalContext.run((IRunnableWithProgress)job, (boolean)true, (IProgressMonitor)SplashHandler.getInstance().getBundleProgressMonitor(), (Display)Display.getCurrent());
                Messages.get();
                Messages.get();
                MessageDialog.openInformation(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Information, (String)Messages.ApplicationWorkbenchWindowAdvisor_PasswordChanged);
                return;
            }
            catch (InvocationTargetException e) {
                Messages.get();
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Error, (String)(String.valueOf(Messages.ApplicationWorkbenchWindowAdvisor_CannotChangePswd) + " " + e.getCause().getLocalizedMessage()));
                continue;
            }
            catch (InterruptedException e) {
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Exception, (String)e.toString());
                continue;
            }
            break;
        }
        return;
    }

    public String keyStoreLocationRequested() {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog dialog = new FileDialog(shell);
        Messages.get();
        dialog.setText(Messages.ApplicationWorkbenchWindowAdvisor_CertDialogTitle);
        dialog.setFilterExtensions(new String[]{"*.p12; *.pfx"});
        String[] stringArray = new String[1];
        Messages.get();
        stringArray[0] = Messages.ApplicationWorkbenchWindowAdvisor_PkcsFiles;
        dialog.setFilterNames(stringArray);
        return dialog.open();
    }

    public String keyStorePasswordRequested() {
        Messages.get();
        Messages.get();
        return this.showPasswordRequestDialog(Messages.ApplicationWorkbenchWindowAdvisor_CertStorePassword, Messages.ApplicationWorkbenchWindowAdvisor_CertStorePasswordMsg);
    }

    public String keyStoreEntryPasswordRequested() {
        Messages.get();
        Messages.get();
        return this.showPasswordRequestDialog(Messages.ApplicationWorkbenchWindowAdvisor_CertPassword, Messages.ApplicationWorkbenchWindowAdvisor_CertPasswordMsg);
    }

    private String showPasswordRequestDialog(String title, String message) {
        Shell shell = Display.getCurrent().getActiveShell();
        PasswordRequestDialog dialog = new PasswordRequestDialog(shell);
        dialog.setTitle(title);
        dialog.setMessage(message);
        if (dialog.open() == 0) {
            return dialog.getPassword();
        }
        return null;
    }

    private void showMessageOfTheDay() {
        LicenseProblem[] licenseProblems;
        NXCSession session = ConsoleSharedData.getSession();
        String message = session.getMessageOfTheDay();
        if (!message.isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Announcement", (String)message);
        }
        if ((licenseProblems = session.getLicenseProblems()) != null && licenseProblems.length > 0) {
            StringBuilder sb = new StringBuilder();
            LicenseProblem[] licenseProblemArray = licenseProblems;
            int n = licenseProblems.length;
            int n2 = 0;
            while (n2 < n) {
                LicenseProblem p = licenseProblemArray[n2];
                if (sb.length() == 0) {
                    sb.append("\r\n");
                }
                sb.append(p.getDescription());
                ++n2;
            }
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"License Problem", (String)sb.toString());
        }
    }
}

