/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.jobs;

import java.lang.reflect.InvocationTargetException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.VersionInfo;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.TwoFactorAuthenticationCallback;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.KeepAliveTimer;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.SourceProvider;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.console.api.SessionProvider;
import org.netxms.ui.eclipse.console.dialogs.TwoFactorMetodSelectionDialog;
import org.netxms.ui.eclipse.console.dialogs.TwoFactorResponseDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LoginJob
implements IRunnableWithProgress {
    private Display display;
    private String server;
    private String loginName;
    private boolean encryptSession;
    private boolean ignoreProtocolVersion;
    private AuthenticationType authMethod;
    private String password;
    private Certificate certificate;
    private Signature signature;

    public LoginJob(Display display, String server, String loginName, boolean encryptSession, boolean ignoreProtocolVersion) {
        this.display = display;
        this.server = server;
        this.loginName = loginName;
        this.encryptSession = encryptSession;
        this.ignoreProtocolVersion = ignoreProtocolVersion;
        this.authMethod = AuthenticationType.PASSWORD;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.LoginJob_connecting, 100);
        try {
            try {
                NXCSession session;
                block14: {
                    block13: {
                        String hostName;
                        int port = 4701;
                        String[] split = this.server.split(":");
                        if (split.length == 2) {
                            hostName = split[0];
                            try {
                                port = Integer.valueOf(split[1]);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            hostName = this.server;
                        }
                        Activator.logInfo("Connecting to " + hostName + " port " + port);
                        session = this.createSession(hostName, port);
                        session.setClientLanguage(Locale.getDefault().getLanguage());
                        session.setClientInfo("nxmc/" + VersionInfo.version());
                        session.setIgnoreProtocolVersion(this.ignoreProtocolVersion);
                        monitor.worked(10);
                        session.connect(new int[]{5});
                        session.login(this.authMethod, this.loginName, this.password, this.certificate, this.signature, new TwoFactorAuthenticationCallback(){

                            public int selectMethod(final List<String> methods) {
                                if (methods.size() == 1) {
                                    return 0;
                                }
                                final int[] selection = new int[]{-1};
                                LoginJob.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TwoFactorMetodSelectionDialog dlg = new TwoFactorMetodSelectionDialog(null, methods);
                                        if (dlg.open() == 0) {
                                            selection[0] = dlg.getSelectedMethod();
                                        }
                                    }
                                });
                                return selection[0];
                            }

                            public String getUserResponse(final String challenge, final String qrLabel) {
                                final String[] response = new String[1];
                                LoginJob.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TwoFactorResponseDialog dlg = new TwoFactorResponseDialog(null, challenge, qrLabel);
                                        if (dlg.open() == 0) {
                                            response[0] = dlg.getResponse();
                                        }
                                    }
                                });
                                return response[0];
                            }
                        });
                        monitor.worked(40);
                        monitor.setTaskName(Messages.LoginJob_sync_objects);
                        final boolean[] objectsFullSync = new boolean[1];
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IPreferenceStore store = ConsoleSharedData.getSettings();
                                objectsFullSync[0] = store.getBoolean("ObjectsFullSync");
                                store.addPropertyChangeListener(new IPropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent event) {
                                        Object value;
                                        boolean doFullSync;
                                        if (event.getProperty().equals("ObjectsFullSync") && (doFullSync = (value = event.getNewValue()) instanceof Boolean ? (Boolean)value : (value instanceof String ? Boolean.valueOf((String)value) : false))) {
                                            Activator.logInfo("Full object synchronization triggered by preference change");
                                            ConsoleJob job = new ConsoleJob("Synchronize all objects", null, "org.netxms.ui.eclipse.console", null){

                                                @Override
                                                protected void runInternal(IProgressMonitor monitor) throws Exception {
                                                    if (!session.areObjectsSynchronized()) {
                                                        session.syncObjects();
                                                    }
                                                }

                                                @Override
                                                protected String getErrorMessage() {
                                                    return "Failed to synchronize all objects";
                                                }
                                            };
                                            job.setUser(false);
                                            job.start();
                                        }
                                    }
                                });
                            }
                        });
                        session.syncObjects(objectsFullSync[0]);
                        monitor.worked(25);
                        Messages.get();
                        monitor.setTaskName(Messages.LoginJob_sync_users);
                        session.subscribeToUserDBUpdates();
                        monitor.worked(5);
                        Messages.get();
                        monitor.setTaskName(Messages.LoginJob_sync_event_db);
                        try {
                            session.syncEventTemplates();
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() == 2) break block13;
                            throw e;
                        }
                    }
                    try {
                        session.syncAlarmCategories();
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 2) break block14;
                        throw e;
                    }
                }
                monitor.worked(5);
                Messages.get();
                monitor.setTaskName(Messages.LoginJob_subscribe);
                session.subscribe("Core.Alarms");
                session.subscribe("Core.GeoAreas");
                monitor.worked(5);
                ConsoleSharedData.setSession(session);
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SourceProvider.getInstance().updateAccessRights(session.getUserSystemRights());
                    }
                });
                Messages.get();
                monitor.setTaskName(Messages.LoginJob_init_extensions);
                TweakletManager.postLogin(session);
                this.callLoginListeners(session);
                monitor.worked(5);
                LoginJob.setupSessionListener(session, this.display);
                Activator.logInfo("Creating keepalive timer");
                new KeepAliveTimer(session).start();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.setTaskName("");
            monitor.done();
        }
        Activator.logInfo("Login job completed");
    }

    private static void setupSessionListener(final NXCSession session, final Display display) {
        session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 13) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SourceProvider.getInstance().updateAccessRights(session.getUserSystemRights());
                        }
                    });
                }
            }
        });
    }

    private NXCSession createSession(String hostName, int port) {
        IConfigurationElement currentElement = null;
        int currentPriotity = 65536;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.sessionproviders");
        int i = 0;
        while (i < elements.length) {
            int priority = 65535;
            String value = elements[i].getAttribute("priority");
            if (value != null) {
                try {
                    priority = Integer.parseInt(value);
                    if (priority < 0 || priority > 65535) {
                        priority = 65535;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (priority < currentPriotity) {
                currentElement = elements[i];
                currentPriotity = priority;
            }
            ++i;
        }
        if (currentElement != null) {
            try {
                SessionProvider p = (SessionProvider)currentElement.createExecutableExtension("class");
                return p.createSession(hostName, port, this.encryptSession);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new NXCSession(hostName, port, this.encryptSession);
    }

    private void callLoginListeners(NXCSession session) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.loginlisteners");
        int i = 0;
        while (i < elements.length) {
            try {
                ConsoleLoginListener listener = (ConsoleLoginListener)elements[i].createExecutableExtension("class");
                listener.afterLogin(session, this.display);
            }
            catch (CoreException e) {
                Activator.logError("Exception in login listener", e);
            }
            ++i;
        }
    }

    public void setPassword(String password) {
        this.password = password;
        this.authMethod = AuthenticationType.PASSWORD;
    }

    public void setCertificate(Certificate certificate, Signature signature) {
        this.certificate = certificate;
        this.signature = signature;
        this.authMethod = AuthenticationType.CERTIFICATE;
    }
}

