/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.widgets.BarChart;
import org.netxms.ui.eclipse.charts.widgets.BarGauge;
import org.netxms.ui.eclipse.charts.widgets.ChartLegend;
import org.netxms.ui.eclipse.charts.widgets.DialGauge;
import org.netxms.ui.eclipse.charts.widgets.LineChart;
import org.netxms.ui.eclipse.charts.widgets.PieChart;
import org.netxms.ui.eclipse.charts.widgets.PlotArea;
import org.netxms.ui.eclipse.charts.widgets.TextGauge;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class Chart
extends Composite {
    private ChartType type = ChartType.LINE;
    private ChartConfiguration configuration;
    protected ChartColor[] palette = null;
    private List<GraphItem> items = new ArrayList<GraphItem>(16);
    private List<DataSeries> dataSeries = new ArrayList<DataSeries>(16);
    private Threshold[][] thresholds;
    private long drillDownObjectId = 0L;
    private ColorCache colorCache;
    private Label title;
    private ChartLegend legend;
    private Composite plotAreaComposite;
    private PlotArea plotArea;
    private boolean mouseDown = false;
    private Set<IDoubleClickListener> doubleClickListeners = new HashSet<IDoubleClickListener>();
    private MenuManager menuManager = null;

    public Chart(Composite parent, int style) {
        this(parent, style, ChartType.LINE, null);
    }

    public Chart(Composite parent, int style, ChartType type, ChartConfiguration configuration) {
        super(parent, style);
        this.colorCache = new ColorCache((Control)this);
        this.createDefaultPalette();
        this.setBackground(this.getColorFromPreferences("Chart.Colors.Background"));
        this.type = type;
        this.configuration = configuration;
        if (configuration != null) {
            this.rebuild();
        }
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    Chart.this.mouseDown = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && Chart.this.mouseDown) {
                    Chart.this.mouseDown = false;
                    if (Chart.this.drillDownObjectId != 0L) {
                        Chart.this.openDrillDownObject();
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Chart.this.mouseDown = false;
                Chart.this.fireDoubleClickListeners();
            }
        });
    }

    private Color getColorFromPreferences(String name) {
        return this.colorCache.create(PreferenceConverter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)name));
    }

    public ChartType getType() {
        return this.type;
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    public boolean hasAxes() {
        return this.type != ChartType.PIE;
    }

    protected List<GraphItem> getItems() {
        return this.items;
    }

    public GraphItem getItem(int index) {
        try {
            return this.items.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    protected List<DataSeries> getDataSeries() {
        return this.dataSeries;
    }

    protected ColorCache getColorCache() {
        return this.colorCache;
    }

    public ChartConfiguration getConfiguration() {
        return this.configuration;
    }

    public void reconfigure(ChartConfiguration configuration) {
        this.configuration = configuration;
        this.rebuild();
    }

    public void rebuild() {
        if (this.plotAreaComposite != null) {
            this.plotAreaComposite.dispose();
        }
        if (this.title != null) {
            this.title.dispose();
        }
        if (this.legend != null) {
            this.legend.dispose();
        }
        if (this.configuration != null) {
            GridLayout layout = new GridLayout();
            layout.numColumns = this.isLegendOnSide() ? 2 : 1;
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            this.setLayout((Layout)layout);
            if (this.configuration.isTitleVisible()) {
                this.createTitle();
            } else {
                this.title = null;
            }
            if (this.configuration.isLegendVisible() && (this.configuration.getLegendPosition() == 1 || this.configuration.getLegendPosition() == 4)) {
                this.createLegend();
            }
            this.createPlotArea();
            if (this.configuration.isLegendVisible() && (this.configuration.getLegendPosition() == 2 || this.configuration.getLegendPosition() == 8)) {
                this.createLegend();
            }
        } else {
            this.plotAreaComposite = null;
            this.plotArea = null;
            this.title = null;
            this.legend = null;
        }
        this.layout(true, true);
    }

    private void createTitle() {
        this.title = new Label((Composite)this, 0);
        this.title.setBackground(this.getBackground());
        this.title.setText(this.configuration.getTitle().replace("&", "&&"));
        this.title.setFont(JFaceResources.getBannerFont());
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.horizontalSpan = this.isLegendOnSide() ? 2 : 1;
        this.title.setLayoutData((Object)gd);
        if (this.menuManager != null) {
            this.title.setMenu(this.menuManager.createContextMenu((Control)this.title));
        }
    }

    private void createLegend() {
        this.legend = new ChartLegend(this, this.isLegendOnSide());
        GridData gd = new GridData();
        if (this.isLegendOnSide()) {
            gd.horizontalAlignment = 0x1000000;
            gd.verticalAlignment = 128;
            gd.grabExcessVerticalSpace = true;
        } else {
            gd.horizontalAlignment = 16384;
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessHorizontalSpace = true;
        }
        this.legend.setLayoutData(gd);
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu((Control)this.legend);
            this.legend.setMenu(menu);
            Control[] controlArray = this.legend.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setMenu(menu);
                ++n2;
            }
        }
    }

    private boolean isLegendOnSide() {
        int legendPosition = this.configuration.getLegendPosition();
        return this.configuration.isLegendVisible() && (legendPosition == 1 || legendPosition == 2);
    }

    private void createPlotArea() {
        switch (this.type) {
            case BAR: {
                this.plotAreaComposite = new BarChart(this);
                this.plotArea = (PlotArea)this.plotAreaComposite;
                break;
            }
            case DIAL: {
                this.plotAreaComposite = new DialGauge(this);
                this.plotArea = (PlotArea)this.plotAreaComposite;
                break;
            }
            case GAUGE: {
                this.plotAreaComposite = new BarGauge(this);
                this.plotArea = (PlotArea)this.plotAreaComposite;
                break;
            }
            case LINE: {
                this.plotAreaComposite = new LineChart(this);
                this.plotArea = (PlotArea)this.plotAreaComposite;
                break;
            }
            case PIE: {
                this.plotAreaComposite = new PieChart(this);
                this.plotArea = (PlotArea)this.plotAreaComposite;
                break;
            }
            case TEXT: {
                this.plotAreaComposite = new TextGauge(this);
                this.plotArea = (PlotArea)this.plotAreaComposite;
                break;
            }
            default: {
                this.plotAreaComposite = new Composite((Composite)this, 0);
                this.plotAreaComposite.setBackground(this.getBackground());
                this.plotArea = null;
            }
        }
        this.plotAreaComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu((Control)this.plotAreaComposite);
            this.plotAreaComposite.setMenu(menu);
            Control[] controlArray = this.plotAreaComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setMenu(menu);
                ++n2;
            }
        }
    }

    public void setPalette(ChartColor[] colors) {
        if (colors != null) {
            this.palette = colors;
        } else {
            this.createDefaultPalette();
        }
    }

    public ChartColor getPaletteEntry(int index) {
        try {
            return this.palette[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setPaletteEntry(int index, ChartColor color) {
        try {
            this.palette[index] = color;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void createDefaultPalette() {
        this.palette = new ChartColor[16];
        int i = 0;
        while (i < 16) {
            this.palette[i] = ChartColor.getDefaultColor(i);
            ++i;
        }
    }

    public int addParameter(GraphItem metric) {
        if (this.items.size() >= 16) {
            return -1;
        }
        this.items.add(metric);
        this.dataSeries.add(new DataSeries());
        return this.items.size() - 1;
    }

    public void removeAllParameters() {
        this.items.clear();
        this.dataSeries.clear();
    }

    public void clearParameters() {
        int i = 0;
        while (i < this.dataSeries.size()) {
            this.dataSeries.set(i, new DataSeries(0.0));
            ++i;
        }
    }

    public void setThresholds(Threshold[][] thresholds) {
        this.thresholds = thresholds;
    }

    public Threshold[] getThreshold(int i) {
        if (this.thresholds == null) {
            return null;
        }
        return this.thresholds.length > i ? this.thresholds[i] : null;
    }

    public void updateParameter(int index, DciData values, boolean updateChart) {
        this.dataSeries.set(index, new DataSeries(values));
        if (updateChart) {
            this.refresh();
        }
    }

    public void updateParameter(int index, double value, boolean updateChart) {
        this.dataSeries.set(index, new DataSeries(value));
        if (updateChart) {
            this.refresh();
        }
    }

    public void updateParameter(int index, DciDataRow value, DataType dataType, boolean updateChart) {
        this.dataSeries.set(index, new DataSeries(value, dataType));
        if (updateChart) {
            this.refresh();
        }
    }

    public void updateParameterThresholds(int index, Threshold[] thresholds) {
        DataSeries series = this.dataSeries.get(index);
        if (series != null) {
            Severity severity = Severity.NORMAL;
            Threshold[] thresholdArray = thresholds;
            int n = thresholds.length;
            int n2 = 0;
            while (n2 < n) {
                Threshold t = thresholdArray[n2];
                if (t.isActive()) {
                    severity = t.getCurrentSeverity();
                    break;
                }
                ++n2;
            }
            series.setActiveThresholdSeverity(severity);
        }
    }

    public void setTimeRange(Date from, Date to) {
        if (this.plotArea instanceof LineChart) {
            ((LineChart)this.plotArea).setTimeRange(from, to);
        }
    }

    public void addError(String message) {
    }

    public void clearErrors() {
    }

    public void adjustXAxis(boolean repaint) {
        if (this.plotArea instanceof LineChart) {
            ((LineChart)this.plotArea).adjustXAxis(repaint);
        }
    }

    public void adjustYAxis(boolean repaint) {
        if (this.plotArea instanceof LineChart) {
            ((LineChart)this.plotArea).adjustYAxis(repaint);
        }
    }

    public void zoomIn() {
        if (this.plotArea instanceof LineChart) {
            ((LineChart)this.plotArea).zoomIn();
        }
    }

    public void zoomOut() {
        if (this.plotArea instanceof LineChart) {
            ((LineChart)this.plotArea).zoomOut();
        }
    }

    public void refresh() {
        if (this.configuration.isLegendVisible() && this.configuration.isExtendedLegend()) {
            this.legend.refresh();
        }
        if (this.plotArea != null) {
            this.plotArea.refresh();
        }
    }

    public void setMenuManager(MenuManager menuManager) {
        this.menuManager = menuManager;
        if (menuManager != null) {
            Control c;
            int n;
            int n2;
            Control[] controlArray;
            Menu menu;
            if (this.title != null) {
                this.title.setMenu(menuManager.createContextMenu((Control)this.title));
            }
            if (this.legend != null) {
                menu = menuManager.createContextMenu((Control)this.legend);
                this.legend.setMenu(menu);
                controlArray = this.legend.getChildren();
                n2 = controlArray.length;
                n = 0;
                while (n < n2) {
                    c = controlArray[n];
                    c.setMenu(menu);
                    ++n;
                }
            }
            if (this.plotAreaComposite != null) {
                menu = menuManager.createContextMenu((Control)this.plotAreaComposite);
                this.plotAreaComposite.setMenu(menu);
                controlArray = this.plotAreaComposite.getChildren();
                n2 = controlArray.length;
                n = 0;
                while (n < n2) {
                    c = controlArray[n];
                    c.setMenu(menu);
                    ++n;
                }
            }
        }
    }

    public long getDrillDownObjectId() {
        return this.drillDownObjectId;
    }

    public void setDrillDownObjectId(long drillDownObjectId) {
        this.drillDownObjectId = drillDownObjectId;
        this.setCursor(this.getDisplay().getSystemCursor(drillDownObjectId != 0L ? 21 : 0));
    }

    void openDrillDownObject() {
        AbstractObject object = ConsoleSharedData.getSession().findObjectById(this.drillDownObjectId);
        if (object == null) {
            return;
        }
        if (!(object instanceof Dashboard) && !(object instanceof NetworkMap)) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            window.getActivePage().showView(object instanceof Dashboard ? "org.netxms.ui.eclipse.dashboard.views.DashboardView" : "org.netxms.ui.eclipse.networkmaps.views.PredefinedMap", Long.toString(object.getObjectId()), 1);
        }
        catch (PartInitException e) {
            MessageDialogHelper.openError((Shell)window.getShell(), (String)"Error", (String)String.format("Cannot open %s view \"%s\" (%s)", object instanceof Dashboard ? "dashboard" : "network map", object.getObjectName(), e.getMessage()));
        }
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.add(listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.add(listener);
    }

    protected void fireDoubleClickListeners() {
        for (IDoubleClickListener l : this.doubleClickListeners) {
            l.doubleClick(null);
        }
    }

    public Image takeSnapshot() {
        Rectangle rect = this.getClientArea();
        Image image = new Image((Device)this.getDisplay(), rect.width, rect.height);
        GC gc = new GC((Drawable)image);
        this.print(gc);
        gc.dispose();
        return image;
    }
}

