/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.packages.PackageInfo;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditPackageMetadataDialog
extends Dialog {
    private PackageInfo packageInfo;
    private LabeledText name;
    private LabeledText description;
    private LabeledText version;
    private LabeledText platform;
    private LabeledText command;
    private Combo type;

    public EditPackageMetadataDialog(Shell parentShell, PackageInfo packageInfo) {
        super(parentShell);
        this.packageInfo = packageInfo;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Package Metadata");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.packageInfo.getName());
        this.name.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.name.setLayoutData((Object)gd);
        this.version = new LabeledText(dialogArea, 0);
        this.version.setLabel("Version");
        this.version.setText(this.packageInfo.getVersion());
        this.version.getTextControl().setTextLimit(31);
        this.version.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.platform = new LabeledText(dialogArea, 0);
        this.platform.setLabel("Platform");
        this.platform.setText(this.packageInfo.getPlatform());
        this.platform.getTextControl().setTextLimit(63);
        this.platform.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)0, (String)"Type", (Object)new GridData(4, 1024, true, false));
        this.type.add("agent-installer");
        this.type.add("executable");
        this.type.add("msi");
        this.type.add("msp");
        this.type.add("tgz");
        this.type.setText(this.packageInfo.getType());
        this.type.setTextLimit(15);
        this.command = new LabeledText(dialogArea, 0);
        this.command.setLabel("Command");
        this.command.setText(this.packageInfo.getCommand());
        this.command.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.command.setLayoutData((Object)gd);
        this.description = new LabeledText(dialogArea, 0);
        this.description.setLabel("Description");
        this.description.setText(this.packageInfo.getDescription());
        this.description.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.description.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        String packageName = this.name.getText().trim();
        if (packageName.isEmpty()) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Package name cannot be empty!");
            return;
        }
        this.packageInfo.setName(packageName);
        this.packageInfo.setType(this.type.getText().trim());
        this.packageInfo.setVersion(this.version.getText().trim());
        this.packageInfo.setPlatform(this.platform.getText().trim());
        this.packageInfo.setCommand(this.command.getText().trim());
        this.packageInfo.setDescription(this.description.getText().trim());
        super.okPressed();
    }
}

