/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.packages.PackageDeploymentListener;
import org.netxms.client.packages.PackageInfo;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Activator;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.agentmanager.dialogs.EditPackageMetadataDialog;
import org.netxms.ui.eclipse.agentmanager.views.PackageDeploymentMonitor;
import org.netxms.ui.eclipse.agentmanager.views.helpers.PackageComparator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.PackageLabelProvider;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class PackageManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.PackageManager";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_VERSION = 3;
    public static final int COLUMN_PLATFORM = 4;
    public static final int COLUMN_FILE = 5;
    public static final int COLUMN_COMMAND = 6;
    public static final int COLUMN_DESCRIPTION = 7;
    private List<PackageInfo> packageList = null;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionUploadToServer;
    private Action actionRemove;
    private Action actionDeploy;
    private Action actionEditMetadata;

    public void createPartControl(Composite parent) {
        String[] stringArray = new String[8];
        Messages.get();
        stringArray[0] = Messages.PackageManager_ColumnID;
        Messages.get();
        stringArray[1] = Messages.PackageManager_ColumnName;
        stringArray[2] = "Type";
        Messages.get();
        stringArray[3] = Messages.PackageManager_ColumnVersion;
        Messages.get();
        stringArray[4] = Messages.PackageManager_ColumnPlatform;
        Messages.get();
        stringArray[5] = Messages.PackageManager_ColumnFile;
        stringArray[6] = "Command";
        Messages.get();
        stringArray[7] = Messages.PackageManager_ColumnDescription;
        String[] names = stringArray;
        int[] widths = new int[]{70, 120, 100, 90, 120, 300, 300, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.viewer.setComparator((ViewerComparator)new PackageComparator());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = PackageManager.this.viewer.getStructuredSelection();
                PackageManager.this.actionDeploy.setEnabled(selection.size() == 1);
                PackageManager.this.actionEditMetadata.setEnabled(selection.size() == 1);
                PackageManager.this.actionRemove.setEnabled(selection.size() > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PackageManager.this.editPackageMetadata();
            }
        });
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                PackageManager.this.refresh();
            }
        };
        Messages.get();
        this.actionUploadToServer = new Action(Messages.PackageManager_InstallAction, SharedIcons.ADD_OBJECT){

            public void run() {
                PackageManager.this.installPackage();
            }
        };
        Messages.get();
        this.actionRemove = new Action(Messages.PackageManager_RemoveAction, SharedIcons.DELETE_OBJECT){

            public void run() {
                PackageManager.this.removePackage();
            }
        };
        Messages.get();
        this.actionDeploy = new Action(Messages.PackageManager_DeployAction, Activator.getImageDescriptor("icons/package_deploy.gif")){

            public void run() {
                PackageManager.this.deployPackage();
            }
        };
        this.actionEditMetadata = new Action("&Edit metadata...", SharedIcons.EDIT){

            public void run() {
                PackageManager.this.editPackageMetadata();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionUploadToServer);
        manager.add((IAction)this.actionRemove);
        manager.add((IAction)this.actionDeploy);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionEditMetadata);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionUploadToServer);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PackageManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionDeploy);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionUploadToServer);
        manager.add((IAction)this.actionEditMetadata);
        manager.add((IAction)this.actionRemove);
    }

    private void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.PackageManager_LoadPkgList, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = session.getInstalledPackages();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PackageManager.this.packageList = list;
                        (this).PackageManager.this.viewer.setInput((Object)list.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.PackageManager_PkgListLoadError;
            }
        }.start();
    }

    private void installPackage() {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 4096);
        Messages.get();
        fd.setText(Messages.PackageManager_SelectFile);
        fd.setFilterExtensions(new String[]{"*.apkg", "*.exe", "*.msi", "*.msp", "*.msu", "*.npi", "*.tgz;*.tar.gz", "*.*"});
        String[] stringArray = new String[8];
        stringArray[0] = "NetXMS Agent Package";
        stringArray[1] = "Executable";
        stringArray[2] = "Windows Installer Package";
        stringArray[3] = "Windows Installer Patch";
        stringArray[4] = "Windows Update Package";
        Messages.get();
        stringArray[5] = Messages.PackageManager_FileTypePackage;
        stringArray[6] = "Compressed TAR Archive";
        Messages.get();
        stringArray[7] = Messages.PackageManager_FileTypeAll;
        fd.setFilterNames(stringArray);
        final String packageFileName = fd.open();
        if (packageFileName == null) {
            return;
        }
        try {
            EditPackageMetadataDialog dlg;
            PackageInfo packageInfo;
            boolean showMetadataDialog = true;
            if (packageFileName.endsWith(".npi")) {
                packageInfo = new PackageInfo(new File(packageFileName));
                showMetadataDialog = false;
            } else {
                File packageFile = new File(packageFileName);
                String name = packageFile.getName();
                if (packageFileName.endsWith(".apkg")) {
                    Pattern pattern = Pattern.compile("^nxagent-([0-9]+\\.[0-9]+\\.[0-9]+)(-[a-zA-Z0-9.]+)?(-[a-zA-Z0-9_]+)?\\.apkg$", 2);
                    Matcher matcher = pattern.matcher(name);
                    if (matcher.matches()) {
                        showMetadataDialog = false;
                        if (matcher.group(2) == null) {
                            packageInfo = new PackageInfo("nxagent", "NetXMS Agent Source Package", name, "agent-installer", "src", matcher.group(1), "");
                        } else {
                            String platform;
                            String os;
                            if (matcher.group(2).startsWith("-aix")) {
                                os = "AIX";
                                if (matcher.group(2).length() > 4) {
                                    os = String.valueOf(os) + " " + matcher.group(2).substring(4);
                                }
                                platform = "AIX-powerpc";
                            } else if (matcher.group(2).equals("-hpux")) {
                                os = "HP-UX";
                                platform = "HP-UX" + matcher.group(3);
                            } else if (matcher.group(2).equals("-linux")) {
                                os = "Linux";
                                platform = matcher.group(3).equals("-arm") ? "Linux-arm*" : "Linux" + matcher.group(3);
                            } else if (matcher.group(2).equals("-solaris")) {
                                os = "Solaris";
                                String arch = matcher.group(3).equals("-sparc") ? "-sun4u" : (matcher.group(3).equals("-i386") ? "-i86pc" : matcher.group(3));
                                platform = "SunOS" + arch;
                            } else {
                                os = matcher.group(2).substring(1);
                                platform = String.valueOf(os) + matcher.group(3);
                                showMetadataDialog = true;
                            }
                            packageInfo = new PackageInfo("nxagent", "NetXMS Agent for " + os, name, "agent-installer", platform, matcher.group(1), "");
                        }
                    } else {
                        packageInfo = new PackageInfo(name, "", name, "executable", "*", "", "");
                    }
                } else if (packageFileName.endsWith(".exe")) {
                    Pattern pattern = Pattern.compile("^nxagent-([0-9]+\\.[0-9]+\\.[0-9]+)(-x64)?\\.exe$", 2);
                    Matcher matcher = pattern.matcher(name);
                    if (matcher.matches()) {
                        packageInfo = new PackageInfo("nxagent", "NetXMS Agent for Windows", name, "agent-installer", "windows-" + (matcher.group(2) == null ? "i386" : "x64"), matcher.group(1), "");
                        showMetadataDialog = false;
                    } else {
                        pattern = Pattern.compile("^nxagent-atm-([0-9]+\\.[0-9]+\\.[0-9]+)(-x64)?\\.exe$", 2);
                        matcher = pattern.matcher(name);
                        if (matcher.matches()) {
                            packageInfo = new PackageInfo("nxagent-atm", "NetXMS Agent for ATM", name, "agent-installer", "windows-" + (matcher.group(2) == null ? "i386" : "x64"), matcher.group(1), "");
                            showMetadataDialog = false;
                        } else {
                            packageInfo = new PackageInfo(name, "", name, "executable", "windows-x64", "", "");
                        }
                    }
                } else if (packageFileName.endsWith(".msi") || packageFileName.endsWith(".msp") || packageFileName.endsWith(".msu")) {
                    packageInfo = new PackageInfo(name.substring(0, name.lastIndexOf(46)), "", name, name.substring(name.lastIndexOf(46) + 1), "windows-x64", "", "");
                } else if (packageFileName.endsWith(".tar.gz") || packageFileName.endsWith(".tgz")) {
                    int suffixLen = packageFileName.endsWith(".tar.gz") ? 7 : 4;
                    packageInfo = new PackageInfo(name.substring(0, name.length() - suffixLen), "", name, "tgz", "*", "", "");
                } else {
                    packageInfo = new PackageInfo(name, "", name, "executable", "*", "", "");
                }
            }
            if (showMetadataDialog && (dlg = new EditPackageMetadataDialog(this.getSite().getShell(), packageInfo)).open() != 0) {
                return;
            }
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.PackageManager_InstallPackage, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager"){

                protected void runInternal(final IProgressMonitor monitor) throws Exception {
                    File packageFile = packageFileName.endsWith(".npi") ? new File(new File(packageFileName).getParent(), packageInfo.getFileName()) : new File(packageFileName);
                    long id = session.installPackage(packageInfo, packageFile, new ProgressListener(){
                        long prevAmount = 0L;

                        public void setTotalWorkAmount(long amount) {
                            Messages.get();
                            monitor.beginTask(Messages.PackageManager_UploadPackage, (int)amount);
                        }

                        public void markProgress(long amount) {
                            monitor.worked((int)(amount - this.prevAmount));
                            this.prevAmount = amount;
                        }
                    });
                    packageInfo.setId(id);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).PackageManager.this.packageList.add(packageInfo);
                            (this).PackageManager.this.viewer.setInput((Object)(this).PackageManager.this.packageList.toArray());
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.PackageManager_InstallError;
                }
            }.start();
        }
        catch (IOException e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.PackageManager_Error, (String)(String.valueOf(Messages.PackageManager_PkgFileOpenError) + e.getLocalizedMessage()));
        }
    }

    private void removePackage() {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.PackageManager_ConfirmDeleteTitle, (String)Messages.PackageManager_ConfirmDeleteText)) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final Object[] packages = this.viewer.getStructuredSelection().toArray();
        final ArrayList removedPackages = new ArrayList();
        Messages.get();
        new ConsoleJob(Messages.PackageManager_DeletePackages, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Object[] objectArray = packages;
                int n = packages.length;
                int n2 = 0;
                while (n2 < n) {
                    Object p = objectArray[n2];
                    session.removePackage(((PackageInfo)p).getId());
                    removedPackages.add(p);
                    ++n2;
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PackageManager.this.packageList.removeAll(removedPackages);
                        (this).PackageManager.this.viewer.setInput((Object)(this).PackageManager.this.packageList.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.PackageManager_PkgDeleteError;
            }
        }.start();
    }

    private void deployPackage() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final PackageInfo pkg = (PackageInfo)selection.getFirstElement();
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        dlg.enableMultiSelection(true);
        if (dlg.open() != 0) {
            return;
        }
        final HashSet<Long> objects = new HashSet<Long>();
        for (AbstractObject o : dlg.getSelectedObjects()) {
            objects.add(o.getObjectId());
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.PackageManager_DeployAgentPackage, null, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.deployPackage(pkg.getId(), objects.toArray(new Long[objects.size()]), new PackageDeploymentListener(){
                    private PackageDeploymentMonitor monitor = null;

                    public void statusUpdate(long nodeId, int status, String message) {
                        if (this.monitor != null) {
                            this.monitor.viewStatusUpdate(nodeId, status, message);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void deploymentStarted() {
                        Object sync;
                        Object object = sync = new Object();
                        synchronized (object) {
                            this.runInUIThread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        monitor = (PackageDeploymentMonitor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.agentmanager.views.PackageDeploymentMonitor", this.toString(), 1);
                                        monitor.setPackageId(pkg.getId());
                                    }
                                    catch (PartInitException e) {
                                        Shell shell = PackageManager.this.getSite().getShell();
                                        Messages.get();
                                        Messages.get();
                                        MessageDialogHelper.openError((Shell)shell, (String)Messages.PackageManager_Error, (String)(String.valueOf(Messages.PackageManager_ErrorOpenView) + e.getLocalizedMessage()));
                                    }
                                    Object object = sync;
                                    synchronized (object) {
                                        sync.notify();
                                    }
                                }
                            });
                            try {
                                sync.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }

                    public void deploymentComplete() {
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PackageManager.this.getSite().getShell();
                                Messages.get();
                                Messages.get();
                                MessageDialogHelper.openInformation((Shell)shell, (String)Messages.PackageManager_Information, (String)Messages.PackageManager_PkgDepCompleted);
                            }
                        });
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.PackageManager_DepStartError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void editPackageMetadata() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final PackageInfo packageInfo = (PackageInfo)selection.getFirstElement();
        EditPackageMetadataDialog dlg = new EditPackageMetadataDialog(this.getSite().getShell(), packageInfo);
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Update package metadata", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.updatePackageMetadata(packageInfo);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PackageManager.this.viewer.update((Object)packageInfo, null);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot update metadata for package";
            }
        }.start();
    }
}

