/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.InputField;
import org.netxms.ui.eclipse.widgets.LabeledControl;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class InputFieldReadDialog
extends Dialog {
    private String title;
    private InputField[] fields;
    private LabeledControl[] controls;
    private Map<String, String> values;

    public static Map<String, String> readInputFields(String title, InputField[] fields) {
        InputFieldReadDialog dlg = new InputFieldReadDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, fields);
        if (dlg.open() != 0) {
            return null;
        }
        return dlg.getValues();
    }

    public InputFieldReadDialog(Shell parentShell, String title, InputField[] fields) {
        super(parentShell);
        this.title = title;
        this.fields = fields;
        this.controls = new LabeledControl[fields.length];
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        int i = 0;
        while (i < this.fields.length) {
            LabeledSpinner c;
            switch (this.fields[i].getType()) {
                case NUMBER: {
                    c = new LabeledSpinner(dialogArea, 0);
                    break;
                }
                case PASSWORD: {
                    c = new LabeledText(dialogArea, 0, 0x400800, 300);
                    break;
                }
                default: {
                    c = new LabeledText(dialogArea, 0, 2048, 300);
                }
            }
            c.setLabel(this.fields[i].getDisplayName());
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            c.setLayoutData((Object)gd);
            this.controls[i] = c;
            ++i;
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.values = new HashMap<String, String>();
        int i = 0;
        while (i < this.fields.length) {
            this.values.put(this.fields[i].getName(), this.controls[i].getText());
            ++i;
        }
        super.okPressed();
    }

    public Map<String, String> getValues() {
        return this.values;
    }
}

