/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.widgets.ObjectCategorySelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class General
extends PropertyPage {
    private Text name;
    private Text alias;
    private ObjectCategorySelector categorySelector;
    private String initialName;
    private String initialAlias;
    private int initialCategory;
    private AbstractObject object;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)Messages.General_ObjectID, (String)Long.toString(this.object.getObjectId()), (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)Messages.General_ObjectClass, (String)this.object.getObjectClassName(), (Object)"WidgetHelper::default_layout_data");
        this.initialName = this.object.getObjectName();
        Messages.get();
        this.name = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)Messages.General_ObjectName, (String)this.initialName, (Object)"WidgetHelper::default_layout_data");
        this.initialAlias = this.object.getAlias();
        this.alias = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Alias", (String)this.initialAlias, (Object)"WidgetHelper::default_layout_data");
        this.initialCategory = this.object.getCategoryId();
        this.categorySelector = new ObjectCategorySelector(dialogArea, 0, 8);
        this.categorySelector.setLabel("Category");
        this.categorySelector.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.categorySelector.setCategoryId(this.initialCategory);
        return dialogArea;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
    }

    protected void applyChanges(final boolean isApply) {
        final String newName = this.name.getText();
        final String newAlias = this.alias.getText();
        final int newCategory = this.categorySelector.getCategoryId();
        if (newName.equals(this.initialName) && newAlias.equals(this.initialAlias) && newCategory == this.initialCategory) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData data = new NXCObjectModificationData(this.object.getObjectId());
        data.setName(newName);
        data.setAlias(newAlias);
        data.setCategoryId(newCategory);
        Messages.get();
        new ConsoleJob(Messages.General_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(data);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.General_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).General.this.initialName = newName;
                            (this).General.this.initialAlias = newAlias;
                            (this).General.this.initialCategory = newCategory;
                            General.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

