/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.interfaces.AutoBindObject;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.client.objects.interfaces.ZoneMember;

public class Cluster
extends DataCollectionTarget
implements ZoneMember,
PollingTarget,
AutoBindObject {
    private int clusterType;
    private List<InetAddressEx> syncNetworks = new ArrayList<InetAddressEx>(1);
    private List<ClusterResource> resources = new ArrayList<ClusterResource>();
    private int zoneId;
    private int autoBindFlags;
    private String autoBindFilter;

    public Cluster(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.clusterType = msg.getFieldAsInt32(262L);
        this.zoneId = msg.getFieldAsInt32(147L);
        int count = msg.getFieldAsInt32(263L);
        long fieldId = 0x28000000L;
        int i = 0;
        while (i < count) {
            this.syncNetworks.add(msg.getFieldAsInetAddressEx(fieldId++));
            ++i;
        }
        count = msg.getFieldAsInt32(265L);
        fieldId = 0x20000000L;
        i = 0;
        while (i < count) {
            this.resources.add(new ClusterResource(msg, fieldId));
            ++i;
            fieldId += 10L;
        }
        this.autoBindFilter = msg.getFieldAsString(321L);
        this.autoBindFlags = msg.getFieldAsInt32(625L);
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public int getClusterType() {
        return this.clusterType;
    }

    public List<InetAddressEx> getSyncNetworks() {
        return this.syncNetworks;
    }

    public List<ClusterResource> getResources() {
        return this.resources;
    }

    @Override
    public String getObjectClassName() {
        return "Cluster";
    }

    @Override
    public int getZoneId() {
        return this.zoneId;
    }

    @Override
    public String getZoneName() {
        Zone zone = this.session.findZone(this.zoneId);
        return zone != null ? zone.getObjectName() : Long.toString(this.zoneId);
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }

    @Override
    public boolean isAutoBindEnabled() {
        return (this.autoBindFlags & 1) > 0;
    }

    @Override
    public boolean isAutoUnbindEnabled() {
        return (this.autoBindFlags & 2) > 0;
    }

    @Override
    public String getAutoBindFilter() {
        return this.autoBindFilter;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Cluster.addString(strings, this.autoBindFilter);
        return strings;
    }

    @Override
    public int getAutoBindFlags() {
        return this.autoBindFlags;
    }
}

