/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.dialogs.NotificationChannelEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.NotificationChannelLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.NotificationChannelListComparator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NotificationChannels
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.NotificationChannels";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_DRIVER = 2;
    public static final int COLUMN_TOTAL_MESSAGES = 3;
    public static final int COLUMN_FAILED_MESSAGES = 4;
    public static final int COLUMN_LAST_STATUS = 5;
    public static final int COLUMN_ERROR_MESSAGE = 6;
    private NXCSession session = ConsoleSharedData.getSession();
    private SessionListener listener;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionNewChannel;
    private Action actionEditChannel;
    private Action actionDeleteChannel;

    public void createPartControl(Composite parent) {
        int[] widths = new int[]{160, 250, 100, 100, 100, 80, 400};
        String[] names = new String[]{"Name", "Description", "Driver", "Messages", "Failures", "Status", "Error message"};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new NotificationChannelLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NotificationChannelListComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NotificationChannels.this.editChannel();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = NotificationChannels.this.viewer.getStructuredSelection();
                NotificationChannels.this.actionEditChannel.setEnabled(selection.size() == 1);
                NotificationChannels.this.actionDeleteChannel.setEnabled(selection.size() > 0);
            }
        });
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"NotificationChannelList.V2");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)NotificationChannels.this.viewer, (IDialogSettings)settings, (String)"NotificationChannelList.V2");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
        final Display display = this.getSite().getShell().getDisplay();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1042) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NotificationChannels.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
    }

    public void dispose() {
        if (this.listener != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                NotificationChannels.this.refresh();
            }
        };
        this.actionNewChannel = new Action("&New...", SharedIcons.ADD_OBJECT){

            public void run() {
                NotificationChannels.this.createNewChannel();
            }
        };
        this.actionEditChannel = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                NotificationChannels.this.editChannel();
            }
        };
        this.actionEditChannel.setEnabled(false);
        this.actionDeleteChannel = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                NotificationChannels.this.deleteChannels();
            }
        };
        this.actionDeleteChannel.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNewChannel);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewChannel);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                NotificationChannels.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNewChannel);
        mgr.add((IAction)this.actionEditChannel);
        mgr.add((IAction)this.actionDeleteChannel);
    }

    private void refresh() {
        new ConsoleJob("Reading list of notification channels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List channels = NotificationChannels.this.session.getNotificationChannels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).NotificationChannels.this.viewer.setInput((Object)channels);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of notification channels";
            }
        }.start();
    }

    private void createNewChannel() {
        NotificationChannelEditDialog dlg = new NotificationChannelEditDialog(this.getSite().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        final NotificationChannel channel = dlg.getChannel();
        new ConsoleJob("Create notification channel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NotificationChannels.this.session.createNotificationChannel(channel);
            }

            protected String getErrorMessage() {
                return "Cannot create notification channel";
            }
        }.start();
    }

    private void editChannel() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final NotificationChannel channel = (NotificationChannel)selection.getFirstElement();
        final NotificationChannelEditDialog dlg = new NotificationChannelEditDialog(this.getSite().getShell(), channel);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Updating notification channel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NotificationChannels.this.session.updateNotificationChannel(channel);
                if (dlg.isNameChanged()) {
                    NotificationChannels.this.session.renameNotificationChannel(channel.getName(), dlg.getNewName());
                }
            }

            protected String getErrorMessage() {
                return "Cannot update notification channel";
            }
        }.start();
    }

    private void deleteChannels() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Channels", (String)"Are you sure you want to delete selected notification channels?")) {
            return;
        }
        final ArrayList<String> channels = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof NotificationChannel)) continue;
            channels.add(((NotificationChannel)o).getName());
        }
        new ConsoleJob("Deleting notification channel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (String name : channels) {
                    NotificationChannels.this.session.deleteNotificationChannel(name);
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete notification channel";
            }
        }.start();
    }
}

