/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.PlotArea;

public abstract class GenericComparisonChart
extends Canvas
implements PlotArea {
    protected Chart chart;
    protected boolean fontsCreated = false;

    public GenericComparisonChart(Chart parent) {
        super((Composite)parent, 0x20000000);
        this.chart = parent;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GenericComparisonChart.this.prepareGCAndRender(e.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GenericComparisonChart.this.disposeFonts();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GenericComparisonChart.this.chart.fireDoubleClickListeners();
            }
        });
    }

    protected abstract void createFonts();

    protected abstract void disposeFonts();

    protected Color getColorFromPreferences(String name) {
        return this.chart.getColorCache().create(PreferenceConverter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)name));
    }

    @Override
    public void refresh() {
        this.redraw();
    }

    private void prepareGCAndRender(GC gc) {
        if (!this.fontsCreated) {
            this.createFonts();
            this.fontsCreated = true;
        }
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        this.render(gc);
    }

    protected abstract void render(GC var1);

    protected String getValueAsDisplayString(GraphItem dci, DataSeries data) {
        return new DataFormatter(dci.getDisplayFormat(), dci.getDataType()).format(data.getCurrentValueAsString());
    }
}

