/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.BrandingProvider;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class BrandingManager {
    private static BrandingManager instance = null;
    private I18n i18n = LocalizationHelper.getI18n(BrandingManager.class);
    private Map<Integer, BrandingProvider> providers = new TreeMap();

    public static BrandingManager getInstance() {
        return instance;
    }

    protected static void create() {
        if (instance == null) {
            instance = new BrandingManager();
        }
    }

    private BrandingManager() {
    }

    public String getProductName() {
        for (BrandingProvider p : this.providers.values()) {
            String name = p.getProductName();
            if (name == null) continue;
            return name;
        }
        return this.i18n.tr("NetXMS");
    }

    public String getConsoleProductName() {
        for (BrandingProvider p : this.providers.values()) {
            String name = p.getConsoleProductName();
            if (name == null) continue;
            return name;
        }
        return this.i18n.tr("NetXMS Management Console");
    }

    public String getDefaultPerspective() {
        for (BrandingProvider p : this.providers.values()) {
            String pid = p.getDefaultPerspective();
            if (pid == null) continue;
            return pid;
        }
        return null;
    }

    public ImageDescriptor getLoginTitleImage() {
        for (BrandingProvider p : this.providers.values()) {
            ImageDescriptor d = p.getLoginTitleImage();
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public RGB getLoginTitleColor() {
        for (BrandingProvider p : this.providers.values()) {
            RGB rgb = p.getLoginTitleColor();
            if (rgb == null) continue;
            return rgb;
        }
        return null;
    }

    public String getLoginTitle() {
        for (BrandingProvider p : this.providers.values()) {
            String t = p.getLoginTitle();
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public Dialog getAboutDialog(Shell parentShell) {
        for (BrandingProvider p : this.providers.values()) {
            Dialog d = p.getAboutDialog(parentShell);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public String getRedirectionURL() {
        for (BrandingProvider p : this.providers.values()) {
            String t = p.getRedirectionURL();
            if (t == null) continue;
            return t;
        }
        return "nxmc";
    }
}

