/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.dialogs.PasswordExpiredDialog;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class PasswordExpiredDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(PasswordExpiredDialog.class);
    private int graceLogins;
    private LabeledText textPassword1;
    private LabeledText textPassword2;
    private String password;

    public PasswordExpiredDialog(Shell parentShell, int graceLogins) {
        super(parentShell);
        this.graceLogins = graceLogins;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Label pic = new Label(dialogArea, 0);
        Image image = ResourceManager.getImage((String)"icons/password.png");
        pic.setImage(image);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        pic.setLayoutData((Object)gd);
        pic.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite editArea = new Composite(dialogArea, 0);
        GridLayout editAreaLayout = new GridLayout();
        editAreaLayout.marginWidth = 0;
        editAreaLayout.marginHeight = 0;
        editArea.setLayout((Layout)editAreaLayout);
        Label msg = new Label(editArea, 64);
        msg.setText(String.format(this.i18n.tr("Your password was expired (%d grace logins left). Please change your password now."), this.graceLogins));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        msg.setLayoutData((Object)gd);
        this.textPassword1 = new LabeledText(editArea, 0, 0x400804);
        this.textPassword1.setLabel(this.i18n.tr("New password:"));
        this.textPassword1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textPassword2 = new LabeledText(editArea, 0, 0x400804);
        this.textPassword2.setLabel(this.i18n.tr("Confirm new password:"));
        this.textPassword2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 250;
        editArea.setLayoutData((Object)gd);
        2 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.textPassword1.getTextControl().addModifyListener((ModifyListener)listener);
        this.textPassword2.getTextControl().addModifyListener((ModifyListener)listener);
        return dialogArea;
    }

    protected boolean validate() {
        String password2;
        String password1 = this.textPassword1.getText();
        boolean ret = password1.equals(password2 = this.textPassword2.getText());
        return ret;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Change Password"));
    }

    protected void okPressed() {
        this.password = this.textPassword1.getText();
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }

    static /* synthetic */ Button access$000(PasswordExpiredDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

