/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.preferencepages;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class Appearance
extends PreferencePage {
    private static final I18n i18n = LocalizationHelper.getI18n(Appearance.class);
    private Button checkVerticalLayout;
    private Button checkShowServerClock;

    public Appearance() {
        super(i18n.tr("Appearance"));
    }

    protected Control createContents(Composite parent) {
        PreferenceStore settings = PreferenceStore.getInstance();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkVerticalLayout = new Button(dialogArea, 32);
        this.checkVerticalLayout.setText("&Vertical layout of perspective switcher");
        this.checkVerticalLayout.setSelection(settings.getAsBoolean("Appearance.VerticalLayout", true));
        this.checkShowServerClock = new Button(dialogArea, 32);
        this.checkShowServerClock.setText("Show server &clock");
        this.checkShowServerClock.setSelection(settings.getAsBoolean("Appearance.ShowServerClock", false));
        return dialogArea;
    }

    private void doApply() {
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("Appearance.VerticalLayout", this.checkVerticalLayout.getSelection());
        settings.set("Appearance.ShowServerClock", this.checkShowServerClock.getSelection());
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return true;
    }
}

