/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewFolderSelectionListener;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.base.views.helpers.NavigationHistory;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.keyboard.KeyBindingManager;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewFolder
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(ViewFolder.class);
    private I18n i18n = LocalizationHelper.getI18n(ViewFolder.class);
    private Window window;
    private Perspective perspective;
    private CTabFolder tabFolder;
    private Composite topRightControl;
    private MenuManager viewMenuManager;
    private ToolBarManager viewToolBarManager;
    private ToolBar viewToolBar;
    private ToolBar viewControlBar;
    private ToolItem viewMenu = null;
    private ToolItem enableFilter = null;
    private ToolItem navigationBack = null;
    private ToolItem navigationForward = null;
    private Object context;
    private NavigationHistory navigationHistory = null;
    private boolean allViewsAreCloseable = false;
    private boolean useGlobalViewId = false;
    private Map<String, View> views = new HashMap();
    private Map<String, CTabItem> tabs = new HashMap();
    private Set<ViewFolderSelectionListener> selectionListeners = new HashSet();
    private Runnable onFilterCloseCallback = null;
    private KeyBindingManager keyBindingManager = new KeyBindingManager();

    public ViewFolder(Window window, Perspective perspective, Composite parent, boolean enableViewExtraction, boolean enableViewPinning, boolean enableNavigationHistory) {
        super(parent, 0);
        this.window = window;
        this.perspective = perspective;
        this.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder((Composite)this, 2176);
        this.tabFolder.setUnselectedCloseVisible(true);
        this.tabFolder.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.topRightControl = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.topRightControl.setLayout((Layout)layout);
        this.tabFolder.setTopRight((Control)this.topRightControl);
        this.viewMenuManager = new MenuManager();
        this.viewToolBarManager = new ToolBarManager(8519744);
        this.viewToolBar = this.viewToolBarManager.createControl(this.topRightControl);
        this.viewToolBar.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewControlBar = new ToolBar(this.topRightControl, 8519744);
        this.viewControlBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        if (enableNavigationHistory) {
            this.navigationBack = new ToolItem(this.viewControlBar, 8);
            this.navigationBack.setImage(SharedIcons.IMG_NAV_BACKWARD);
            this.navigationBack.setToolTipText(this.i18n.tr("Back (Alt+Left)"));
            this.navigationBack.setEnabled(false);
            this.navigationBack.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000003, (IAction)new /* Unavailable Anonymous Inner Class!! */);
            this.navigationForward = new ToolItem(this.viewControlBar, 8);
            this.navigationForward.setImage(SharedIcons.IMG_NAV_FORWARD);
            this.navigationForward.setToolTipText(this.i18n.tr("Forward (Alt+Right)"));
            this.navigationForward.setEnabled(false);
            this.navigationForward.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000004, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        ToolItem refreshView = new ToolItem(this.viewControlBar, 8);
        refreshView.setImage(SharedIcons.IMG_REFRESH);
        refreshView.setToolTipText(this.i18n.tr("Refresh (F5)"));
        refreshView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.onFilterCloseCallback = new /* Unavailable Anonymous Inner Class!! */;
        if (enableViewPinning) {
            ToolItem pinView = new ToolItem(this.viewControlBar, 8);
            pinView.setImage(SharedIcons.IMG_PIN);
            pinView.setToolTipText(this.i18n.tr("Add view to pinboard (F7)"));
            pinView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000010, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (enableViewExtraction) {
            ToolItem popOutView = new ToolItem(this.viewControlBar, 8);
            popOutView.setImage(SharedIcons.IMG_POP_OUT);
            popOutView.setToolTipText(this.i18n.tr("Pop out view (F8)"));
            popOutView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000011, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.keyBindingManager.addBinding(262144, 0x100000B, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        this.keyBindingManager.addBinding("M1+F", (IAction)new /* Unavailable Anonymous Inner Class!! */);
        this.keyBindingManager.addBinding(0, 0x1000013, (IAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void pinActiveView() {
        View clone;
        View view = this.getActiveView();
        if (view != null && (clone = view.cloneView()) != null) {
            Registry.getMainWindow().pinView(clone);
        }
    }

    private void extractActiveView() {
        View clone;
        View view = this.getActiveView();
        if (view != null && (clone = view.cloneView()) != null) {
            PopOutViewWindow window = new PopOutViewWindow(clone);
            window.open();
        }
    }

    public void addView(View view) {
        this.addView(view, false, false);
    }

    public void addView(View view, boolean activate, boolean ignoreContext) {
        CTabItem tabItem;
        String viewId = this.getViewId(view);
        View currentView = (View)this.views.get(viewId);
        if (currentView != null) {
            if (currentView == view) {
                return;
            }
            currentView.dispose();
            tabItem = (CTabItem)this.tabs.remove(viewId);
            if (tabItem != null) {
                tabItem.dispose();
            }
        }
        this.views.put(viewId, view);
        if (ignoreContext || !(view instanceof ViewWithContext) || ((ViewWithContext)view).isValidForContext(this.context)) {
            view.create(this.window, this.perspective, (Composite)this.tabFolder, this.onFilterCloseCallback);
            tabItem = this.createViewTab(view, ignoreContext);
            if (activate) {
                this.tabFolder.setSelection(tabItem);
                this.activateView(view, tabItem);
            }
        }
    }

    public void removeView(String id) {
        View view = (View)this.views.remove(id);
        if (view != null) {
            view.dispose();
            CTabItem tabItem = (CTabItem)this.tabs.remove(this.getViewId(view));
            if (tabItem != null) {
                tabItem.dispose();
            }
        }
    }

    private void activateView(View view, CTabItem tabItem) {
        if (view instanceof ViewWithContext && !ViewFolder.ignoreContextForView((CTabItem)tabItem) && ((ViewWithContext)view).getContext() != this.context) {
            ((ViewWithContext)view).setContext(this.context);
        }
        this.viewToolBarManager.removeAll();
        view.fillLocalToolbar(this.viewToolBarManager);
        this.viewToolBarManager.update(true);
        this.viewMenuManager.removeAll();
        view.fillLocalMenu(this.viewMenuManager);
        if (!this.viewMenuManager.isEmpty()) {
            if (this.viewMenu == null) {
                this.viewMenu = new ToolItem(this.viewControlBar, 8, this.viewControlBar.getItemCount());
                this.viewMenu.setImage(SharedIcons.IMG_VIEW_MENU);
                this.viewMenu.setToolTipText(this.i18n.tr("View menu (F10)"));
                this.viewMenu.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else if (this.viewMenu != null) {
            this.viewMenu.dispose();
            this.viewMenu = null;
        }
        if (view.hasFilter()) {
            if (this.enableFilter == null) {
                this.enableFilter = new ToolItem(this.viewControlBar, 32, this.navigationBack != null ? 2 : 0);
                this.enableFilter.setImage(SharedIcons.IMG_FILTER);
                this.enableFilter.setToolTipText(String.format(this.i18n.tr("Show filter (%s)"), KeyStroke.normalizeDefinition((String)"M1+F2")));
                this.enableFilter.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.enableFilter.setSelection(view.isFilterEnabled());
        } else if (this.enableFilter != null) {
            this.enableFilter.dispose();
            this.enableFilter = null;
        }
        if (this.navigationBack != null && this.navigationForward != null) {
            this.navigationHistory = view instanceof NavigationView ? ((NavigationView)view).getNavigationHistory() : null;
            this.navigationForward.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoForward());
            this.navigationBack.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoBackward());
        }
        view.activate();
    }

    private void showViewMenu() {
        if (this.viewMenuManager.isEmpty()) {
            return;
        }
        Menu menu = this.viewMenuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.viewMenu.getBounds();
        menu.setLocation(this.viewControlBar.toDisplay(new Point(bounds.x, bounds.y + bounds.height + 2)));
        menu.setVisible(true);
    }

    public boolean updateViewTrim(View view) {
        boolean updated = false;
        CTabItem tab = (CTabItem)this.tabs.get(this.getViewId(view));
        if (tab != null) {
            tab.setText(ViewFolder.ignoreContextForView((CTabItem)tab) ? view.getFullName() : view.getName());
            tab.setImage(view.getImage());
            updated = true;
        }
        return updated;
    }

    private CTabItem createViewTab(View view, boolean ignoreContext) {
        int index = 0;
        int priority = view.getPriority();
        for (CTabItem i : this.tabFolder.getItems()) {
            if (((View)i.getData("view")).getPriority() > priority) break;
            ++index;
        }
        CTabItem tabItem = new CTabItem(this.tabFolder, 0, index);
        tabItem.setControl((Control)view.getViewArea());
        tabItem.setText(ignoreContext ? view.getFullName() : view.getName());
        tabItem.setImage(view.getImage());
        tabItem.setData("view", (Object)view);
        tabItem.setData("ignoreContext", (Object)ignoreContext);
        tabItem.setShowClose(this.allViewsAreCloseable || view.isCloseable());
        tabItem.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabs.put(this.getViewId(view), tabItem);
        return tabItem;
    }

    public void setContext(Object context) {
        View activeView;
        this.context = context;
        for (View view : this.views.values()) {
            if (!(view instanceof ViewWithContext)) continue;
            if (((ViewWithContext)view).isValidForContext(context)) {
                view.setVisible(true);
                if (this.tabs.containsKey(this.getViewId(view))) continue;
                if (view.isCreated()) {
                    view.setVisible(true);
                } else {
                    view.create(this.window, this.perspective, (Composite)this.tabFolder, this.onFilterCloseCallback);
                }
                this.createViewTab(view, false);
                continue;
            }
            String viewId = this.getViewId(view);
            CTabItem tabItem = (CTabItem)this.tabs.remove(viewId);
            if (tabItem == null) continue;
            logger.debug("View " + viewId + " is not valid for current context");
            tabItem.setData("keepView", (Object)Boolean.TRUE);
            tabItem.dispose();
            view.setVisible(false);
        }
        if (this.tabFolder.getSelectionIndex() == -1) {
            this.tabFolder.setSelection(0);
        }
        if ((activeView = this.getActiveView()) instanceof ViewWithContext) {
            ((ViewWithContext)activeView).setContext(context);
        }
    }

    public View getActiveView() {
        if (this.tabFolder.isDisposed()) {
            return null;
        }
        CTabItem selection = this.tabFolder.getSelection();
        return selection != null && !selection.isDisposed() ? (View)selection.getData("view") : null;
    }

    private void navigateBack() {
        if (this.navigationHistory == null || !this.navigationHistory.canGoBackward()) {
            return;
        }
        this.navigationHistory.lock();
        ((NavigationView)this.getActiveView()).setSelection(this.navigationHistory.back());
        this.navigationHistory.unlock();
        this.navigationBack.setEnabled(this.navigationHistory.canGoBackward());
        this.navigationForward.setEnabled(this.navigationHistory.canGoForward());
    }

    private void navigateForward() {
        if (this.navigationHistory == null || !this.navigationHistory.canGoForward()) {
            return;
        }
        this.navigationHistory.lock();
        ((NavigationView)this.getActiveView()).setSelection(this.navigationHistory.forward());
        this.navigationHistory.unlock();
        this.navigationBack.setEnabled(this.navigationHistory.canGoBackward());
        this.navigationForward.setEnabled(this.navigationHistory.canGoForward());
    }

    public NavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    protected void updateNavigationControls() {
        if (this.navigationForward != null) {
            this.navigationForward.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoForward());
        }
        if (this.navigationBack != null) {
            this.navigationBack.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoBackward());
        }
    }

    public void addSelectionListener(ViewFolderSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(ViewFolderSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void fireSelectionListeners(View view) {
        for (ViewFolderSelectionListener l : this.selectionListeners) {
            l.viewSelected(view);
        }
    }

    public boolean areAllViewsCloseable() {
        return this.allViewsAreCloseable;
    }

    public void setAllViewsAsCloseable(boolean allViewsAreCloseable) {
        this.allViewsAreCloseable = allViewsAreCloseable;
    }

    private static boolean ignoreContextForView(CTabItem tabItem) {
        Object ignoreContext = tabItem.getData("ignoreContext");
        return ignoreContext != null && ignoreContext instanceof Boolean && (Boolean)ignoreContext != false;
    }

    public boolean isUseGlobalViewId() {
        return this.useGlobalViewId;
    }

    public void setUseGlobalViewId(boolean useGlobalViewId) {
        this.useGlobalViewId = useGlobalViewId;
    }

    private String getViewId(View view) {
        return this.useGlobalViewId ? view.getGlobalId() : view.getBaseId();
    }

    public boolean setFocus() {
        View view = this.getActiveView();
        if (view != null && !view.isClientAreaDisposed()) {
            view.setFocus();
        } else {
            super.setFocus();
        }
        return true;
    }

    public void processKeyStroke(KeyStroke ks) {
        View view;
        if (!this.keyBindingManager.processKeyStroke(ks) && (view = this.getActiveView()) != null) {
            view.processKeyStroke(ks);
        }
    }
}

