/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.Stack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.base.views.helpers.NavigationHistory;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.keyboard.KeyBindingManager;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ViewStack
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(ViewStack.class);
    private I18n i18n = LocalizationHelper.getI18n(ViewStack.class);
    private Window window;
    private Perspective perspective;
    private Stack<View> views = new Stack();
    private boolean contextAware = true;
    private Object context;
    private ToolBar viewList;
    private MenuManager viewMenuManager;
    private ToolBarManager viewToolBarManager;
    private ToolBar viewToolBar;
    private ToolBar viewControlBar;
    private Composite viewArea;
    private Runnable onFilterCloseCallback = null;
    private ToolItem viewMenu = null;
    private ToolItem enableFilter = null;
    private ToolItem navigationBack = null;
    private ToolItem navigationForward = null;
    private NavigationHistory navigationHistory = null;
    private KeyBindingManager keyBindingManager = new KeyBindingManager();

    public ViewStack(Window window, Perspective perspective, Composite parent, boolean enableViewExtraction, boolean enableViewPinning, boolean enableNavigationHistory) {
        super(parent, 2048);
        this.window = window;
        this.perspective = perspective;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.viewList = new ToolBar((Composite)this, 0x804040);
        this.viewList.setFont(JFaceResources.getBannerFont());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewList.setLayoutData((Object)gd);
        this.viewMenuManager = new MenuManager();
        this.viewToolBarManager = new ToolBarManager(8519744);
        this.viewToolBar = this.viewToolBarManager.createControl((Composite)this);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        this.viewToolBar.setLayoutData((Object)gd);
        this.viewControlBar = new ToolBar((Composite)this, 8519744);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        this.viewControlBar.setLayoutData((Object)gd);
        if (enableNavigationHistory) {
            this.navigationBack = new ToolItem(this.viewControlBar, 8);
            this.navigationBack.setImage(SharedIcons.IMG_NAV_BACKWARD);
            this.navigationBack.setToolTipText(this.i18n.tr("Back (Alt+Left)"));
            this.navigationBack.setEnabled(false);
            this.navigationBack.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000003, (IAction)new /* Unavailable Anonymous Inner Class!! */);
            this.navigationForward = new ToolItem(this.viewControlBar, 8);
            this.navigationForward.setImage(SharedIcons.IMG_NAV_FORWARD);
            this.navigationForward.setToolTipText(this.i18n.tr("Forward (Alt+Right)"));
            this.navigationForward.setEnabled(false);
            this.navigationForward.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000004, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.onFilterCloseCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.keyBindingManager.addBinding(262144, 0x100000B, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        this.keyBindingManager.addBinding("M1+F", (IAction)new /* Unavailable Anonymous Inner Class!! */);
        this.keyBindingManager.addBinding(0, 0x1000013, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        ToolItem refreshView = new ToolItem(this.viewControlBar, 8);
        refreshView.setImage(SharedIcons.IMG_REFRESH);
        refreshView.setToolTipText(this.i18n.tr("Refresh (F5)"));
        refreshView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (enableViewPinning) {
            ToolItem pinView = new ToolItem(this.viewControlBar, 8);
            pinView.setImage(SharedIcons.IMG_PIN);
            pinView.setToolTipText(this.i18n.tr("Add view to pinboard (F7)"));
            pinView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000010, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (enableViewExtraction) {
            ToolItem popOutView = new ToolItem(this.viewControlBar, 8);
            popOutView.setImage(SharedIcons.IMG_POP_OUT);
            popOutView.setToolTipText(this.i18n.tr("Pop out view (F8)"));
            popOutView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000011, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        Label separator = new Label((Composite)this, 258);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gd);
        this.viewArea = new Composite((Composite)this, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.viewArea.setLayoutData((Object)gd);
        this.viewArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void pinActiveView() {
        View clone;
        View view = this.getView();
        if (view != null && (clone = view.cloneView()) != null) {
            Registry.getMainWindow().pinView(clone);
        }
    }

    private void extractActiveView() {
        View clone;
        View view = this.getView();
        if (view != null && (clone = view.cloneView()) != null) {
            PopOutViewWindow window = new PopOutViewWindow(clone);
            window.open();
        }
    }

    public void setView(View view) {
        for (View v : this.views) {
            logger.debug("Existing view " + v.getGlobalId() + " replaced by view " + (view != null ? view.getGlobalId() : "(null)"));
            v.dispose();
        }
        this.views.clear();
        if (view != null) {
            this.pushViewInternal(view);
        } else {
            this.navigationHistory = null;
            if (this.navigationForward != null) {
                this.navigationForward.setEnabled(false);
            }
            if (this.navigationBack != null) {
                this.navigationBack.setEnabled(false);
            }
        }
        this.updateViewList();
    }

    public void pushView(View view) {
        if (view == null) {
            return;
        }
        this.pushViewInternal(view);
        this.addViewListElement(view);
    }

    private void pushViewInternal(View view) {
        this.views.push(view);
        view.create(this.window, this.perspective, this.viewArea, this.onFilterCloseCallback);
        if (this.contextAware && view instanceof ViewWithContext) {
            ((ViewWithContext)view).setContext(this.context);
        }
        this.activateView(view);
    }

    public boolean popView() {
        if (this.views.empty()) {
            return true;
        }
        View view = (View)this.views.pop();
        if (view instanceof ConfigurationView && ((ConfigurationView)view).isModified()) {
            int choice = MessageDialogHelper.openQuestionWithCancel((Shell)view.getWindow().getShell(), (String)this.i18n.tr("Unsaved Changes"), (String)((ConfigurationView)view).getSaveOnExitPrompt());
            if (choice == 2) {
                this.views.push(view);
                return false;
            }
            if (choice == 0) {
                ((ConfigurationView)view).save();
            }
        }
        view.dispose();
        int count = this.viewList.getItemCount();
        this.viewList.getItem(--count).dispose();
        if (count > 0) {
            this.viewList.getItem(--count).dispose();
        }
        if ((view = this.getView()) == null) {
            return true;
        }
        this.activateView(view);
        return true;
    }

    private void activateView(View view) {
        this.viewToolBarManager.removeAll();
        view.fillLocalToolbar(this.viewToolBarManager);
        this.viewToolBarManager.update(true);
        boolean controlBarChanged = false;
        this.viewMenuManager.removeAll();
        view.fillLocalMenu(this.viewMenuManager);
        if (!this.viewMenuManager.isEmpty()) {
            if (this.viewMenu == null) {
                this.viewMenu = new ToolItem(this.viewControlBar, 8, this.viewControlBar.getItemCount());
                this.viewMenu.setImage(SharedIcons.IMG_VIEW_MENU);
                this.viewMenu.setToolTipText(this.i18n.tr("View menu (F10)"));
                this.viewMenu.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
                controlBarChanged = true;
            }
        } else if (this.viewMenu != null) {
            this.viewMenu.dispose();
            this.viewMenu = null;
            controlBarChanged = true;
        }
        if (view.hasFilter()) {
            if (this.enableFilter == null) {
                this.enableFilter = new ToolItem(this.viewControlBar, 32, this.navigationBack != null ? 2 : 0);
                this.enableFilter.setImage(SharedIcons.IMG_FILTER);
                this.enableFilter.setToolTipText(String.format(this.i18n.tr("Show filter (%s)"), KeyStroke.normalizeDefinition((String)"M1+F2")));
                this.enableFilter.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
                controlBarChanged = true;
            }
            this.enableFilter.setSelection(view.isFilterEnabled());
        } else if (this.enableFilter != null) {
            this.enableFilter.dispose();
            this.enableFilter = null;
            controlBarChanged = true;
        }
        if (controlBarChanged) {
            this.layout(true, true);
        }
        NavigationHistory navigationHistory = this.navigationHistory = view instanceof NavigationView ? ((NavigationView)view).getNavigationHistory() : null;
        if (this.navigationForward != null) {
            this.navigationForward.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoForward());
        }
        if (this.navigationBack != null) {
            this.navigationBack.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoBackward());
        }
        view.getViewArea().setSize(this.viewArea.getSize());
        view.activate();
    }

    public void switchToView(View view) {
        if (!this.views.contains(view)) {
            return;
        }
        while (this.getView() != view && this.popView()) {
        }
    }

    public View getView() {
        return this.views.empty() ? null : (View)this.views.peek();
    }

    private void showViewMenu() {
        if (this.viewMenuManager.isEmpty()) {
            return;
        }
        Menu menu = this.viewMenuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.viewMenu.getBounds();
        menu.setLocation(this.viewControlBar.toDisplay(new Point(bounds.x, bounds.y + bounds.height + 2)));
        menu.setVisible(true);
    }

    private void navigateBack() {
        if (this.navigationHistory == null || !this.navigationHistory.canGoBackward()) {
            return;
        }
        this.navigationHistory.lock();
        ((NavigationView)this.getView()).setSelection(this.navigationHistory.back());
        this.navigationHistory.unlock();
        this.navigationBack.setEnabled(this.navigationHistory.canGoBackward());
        this.navigationForward.setEnabled(this.navigationHistory.canGoForward());
    }

    private void navigateForward() {
        if (this.navigationHistory == null || !this.navigationHistory.canGoForward()) {
            return;
        }
        this.navigationHistory.lock();
        ((NavigationView)this.getView()).setSelection(this.navigationHistory.forward());
        this.navigationHistory.unlock();
        this.navigationBack.setEnabled(this.navigationHistory.canGoBackward());
        this.navigationForward.setEnabled(this.navigationHistory.canGoForward());
    }

    public NavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    protected void updateNavigationControls() {
        if (this.navigationForward != null) {
            this.navigationForward.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoForward());
        }
        if (this.navigationBack != null) {
            this.navigationBack.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoBackward());
        }
    }

    public void setContext(Object context) {
        this.context = context;
        View view = this.getView();
        if (this.contextAware && view != null && view instanceof ViewWithContext) {
            ((ViewWithContext)view).setContext(context);
        }
    }

    public boolean isContextAware() {
        return this.contextAware;
    }

    public void setContextAware(boolean contextAware) {
        this.contextAware = contextAware;
    }

    public boolean setFocus() {
        View view = this.getView();
        if (view != null && !view.isClientAreaDisposed()) {
            view.setFocus();
        } else {
            this.viewArea.setFocus();
        }
        return true;
    }

    public void processKeyStroke(KeyStroke ks) {
        if (this.keyBindingManager.processKeyStroke(ks)) {
            return;
        }
        View view = this.getView();
        if (view != null) {
            view.processKeyStroke(ks);
        }
    }

    private void updateViewList() {
        for (ToolItem i : this.viewList.getItems()) {
            i.dispose();
        }
        for (View v : this.views) {
            this.addViewListElement(v);
        }
    }

    private void addViewListElement(View view) {
        ToolItem i;
        if (this.viewList.getItemCount() > 0) {
            i = new ToolItem(this.viewList, 8);
            i.setText(">");
            i.setEnabled(false);
        }
        i = new ToolItem(this.viewList, 8);
        i.setText(view.getFullName());
        i.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

