/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.base.widgets.helpers.AbstractTraceViewFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractTraceWidget
extends Composite {
    private static final I18n i18n = LocalizationHelper.getI18n(AbstractTraceWidget.class);
    private static final int MAX_ELEMENTS = 500;
    private View view;
    private FilterText filterText;
    private TableViewer viewer;
    private LinkedList<Object> data = new LinkedList();
    private AbstractTraceViewFilter filter = null;
    private boolean paused = false;
    private boolean filterEnabled = true;
    private long lastUpdated = 0L;
    private boolean updateScheduled = false;
    private Action actionPause;
    private Action actionCopy;

    public AbstractTraceWidget(Composite parent, int style, View view) {
        super(parent, style);
        this.view = view;
        this.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText((Composite)this, 0);
        this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer = new TableViewer((Composite)this, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setupViewer(this.viewer);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (String)this.getConfigPrefix());
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.createPopupMenu();
        this.enableFilter(this.filterEnabled);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createActions() {
        this.actionPause = new /* Unavailable Anonymous Inner Class!! */;
        this.actionPause.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/pause.png"));
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IContributionItem)new Separator());
    }

    public boolean setFocus() {
        return this.viewer.getControl().setFocus();
    }

    protected abstract void setupViewer(TableViewer var1);

    protected void addColumn(String name, int width) {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(name);
        tc.setWidth(width);
    }

    protected void addElement(Object element) {
        if (this.data.size() == 500) {
            this.data.removeLast();
        }
        this.data.addFirst(element);
        if (!this.paused) {
            long now = System.currentTimeMillis();
            if (now - this.lastUpdated > 200L) {
                this.viewer.setInput((Object)this.data.toArray());
                this.lastUpdated = now;
            } else if (!this.updateScheduled) {
                this.updateScheduled = true;
                this.getDisplay().timerExec(200, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void clear() {
        this.data.clear();
        this.viewer.setInput((Object)new Object[0]);
    }

    protected void refresh() {
        this.viewer.refresh();
    }

    protected boolean isPaused() {
        return this.paused;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
        if (!paused) {
            this.viewer.setInput((Object)this.data.toArray());
        }
    }

    protected abstract String getConfigPrefix();

    protected void saveConfig() {
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout(true, true);
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    protected void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        if (this.filter != null) {
            this.filter.setFilterString(text);
            this.viewer.refresh(false);
        }
    }

    protected void setFilter(AbstractTraceViewFilter filter) {
        if (this.filter != null) {
            this.viewer.removeFilter((ViewerFilter)this.filter);
        }
        this.filter = filter;
        this.viewer.addFilter((ViewerFilter)filter);
    }

    public void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }

    protected void runInUIThread(Runnable runnable) {
        this.getDisplay().asyncExec(runnable);
    }

    private void copySelectionToClipboard() {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            StringBuilder sb = new StringBuilder();
            String newLine = WidgetHelper.getNewLineCharacters();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(0));
                for (int j = 1; j < this.viewer.getTable().getColumnCount(); ++j) {
                    sb.append('\t');
                    sb.append(selection[i].getText(j));
                }
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    public Action getActionPause() {
        return this.actionPause;
    }

    public Action getActionCopy() {
        return this.actionCopy;
    }

    protected View getView() {
        return this.view;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }
}

