/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.keyboard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.netxms.nxmc.keyboard.KeyStroke;

public class KeyBindingManager {
    private Map<KeyStroke, IAction> bindings = new HashMap();

    public void addBinding(KeyStroke keyStroke, IAction action) {
        this.bindings.put(keyStroke, action);
        String text = action.getText();
        if (text != null && text.indexOf(9) == -1) {
            action.setText(text + "\t" + keyStroke.toString());
        }
    }

    public void addBinding(String definition, IAction action) {
        KeyStroke keyStroke = KeyStroke.parse((String)definition);
        if (keyStroke.isValid()) {
            this.addBinding(keyStroke, action);
        }
    }

    public void addBinding(int modifiers, int key, IAction action) {
        this.addBinding(new KeyStroke(modifiers, key), action);
    }

    public void removeBinding(KeyStroke keyStroke) {
        this.bindings.remove(keyStroke);
    }

    public void removeBinding(String definition) {
        this.bindings.remove(KeyStroke.parse((String)definition));
    }

    public void removeBinding(int modifiers, int key) {
        this.bindings.remove(new KeyStroke(modifiers, key));
    }

    public void removeBinding(IAction action) {
        KeyStroke key = null;
        for (Map.Entry e : this.bindings.entrySet()) {
            if (!action.equals(e.getValue())) continue;
            key = (KeyStroke)e.getKey();
            break;
        }
        if (key != null) {
            this.bindings.remove(key);
        }
    }

    public boolean processKeyStroke(KeyStroke keyStroke) {
        IAction action = (IAction)this.bindings.get(keyStroke);
        if (action == null || !action.isEnabled()) {
            return false;
        }
        Display.getCurrent().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }
}

