/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class SaveConfigDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(SaveConfigDialog.class);
    public static final int SAVE_ID = 100;
    public static final int SAVE_AND_APPLY_ID = 101;
    public static final int DISCARD_ID = 102;

    public SaveConfigDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Unsaved Changes"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 100, this.i18n.tr("&Save"), false);
        this.createButton(parent, 101, this.i18n.tr("Save && &Apply"), false);
        this.createButton(parent, 102, this.i18n.tr("&Discard"), false);
        this.createButton(parent, 1, this.i18n.tr("Cancel"), false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Label image = new Label(dialogArea, 0);
        image.setImage(ResourceManager.getImage((String)"icons/unsaved_config.png"));
        image.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        CLabel text = new CLabel(dialogArea, 16384);
        text.setText(this.i18n.tr("Agent's configuration has been modified. Please select one of the following actions:\n\t\"Save\"\t\tSave new configuration\n\t\"Save && Apply\"\tSave new configuration and apply it\n\t\"Discard\"\tDiscard changes\n\t\"Cancel\"\t\tReturn to editing configuration"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        text.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId >= 100) {
            this.setReturnCode(buttonId);
            this.close();
        }
        super.buttonPressed(buttonId);
    }
}

