/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.packages.PackageInfo;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.dialogs.SelectDeployPackage;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.PackageComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.PackageLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SelectDeployPackage
extends Dialog {
    private static I18n i18n = LocalizationHelper.getI18n(SelectDeployPackage.class);
    private TableViewer packageList;
    private NXCSession session = Registry.getSession();
    private long packageId;

    public SelectDeployPackage(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Select Deployment Package"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name"), i18n.tr("Type"), i18n.tr("Version"), i18n.tr("Platform"), i18n.tr("File"), "Command", i18n.tr("Description")};
        int[] widths = new int[]{70, 120, 100, 90, 120, 300, 300, 400};
        this.packageList = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.packageList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.packageList.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.packageList.setComparator((ViewerComparator)new PackageComparator());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 600;
        this.packageList.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.getPackagesAndRefresh();
        return content;
    }

    private void getPackagesAndRefresh() {
        this.packageList.setInput((Object)new String[]{"Loading..."});
        this.getButton(0).setEnabled(false);
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.packageList.getSelection();
        if (sel.size() != 1) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("You must select one package from the list and then press OK."));
            return;
        }
        this.packageId = ((PackageInfo)sel.getFirstElement()).getId();
        super.okPressed();
    }

    public long getSelectedPackageId() {
        return this.packageId;
    }

    static /* synthetic */ Button access$000(SelectDeployPackage x0, int x1) {
        return x0.getButton(x1);
    }
}

