/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.businessservice.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BaseBusinessService;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectAutoBind
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(ObjectAutoBind.class);
    private BaseBusinessService businessService;
    private Button checkboxEnableBind;
    private Button checkboxEnableUnbind;
    private Combo thresholdCombo;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialAutoBindFilter;
    private int initialStatusThreshold;

    public ObjectAutoBind(AbstractObject object) {
        super(i18n.tr("Object Auto Bind"), object);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.businessService = (BaseBusinessService)this.object;
        if (this.businessService == null) {
            return dialogArea;
        }
        this.initialBind = this.businessService.isAutoBindEnabled();
        this.initialUnbind = this.businessService.isAutoUnbindEnabled();
        this.initialAutoBindFilter = this.businessService.getAutoBindFilter();
        this.initialAutoBindFilter = this.businessService.getAutoBindFilter();
        this.initialStatusThreshold = this.businessService.getObjectStatusThreshold();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableBind = new Button(dialogArea, 32);
        this.checkboxEnableBind.setText("Automatically add objects selected by filter to this business service as check");
        this.checkboxEnableBind.setSelection(this.businessService.isAutoBindEnabled());
        this.checkboxEnableBind.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkboxEnableUnbind = new Button(dialogArea, 32);
        this.checkboxEnableUnbind.setText("Automatically remove objects selected by filter from this business service");
        this.checkboxEnableUnbind.setSelection(this.businessService.isAutoUnbindEnabled());
        this.checkboxEnableUnbind.setEnabled(this.businessService.isAutoBindEnabled());
        this.thresholdCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Status Threashold"), (Object)new GridData());
        this.thresholdCombo.add(i18n.tr("Default"));
        for (int i = 1; i <= 4; ++i) {
            this.thresholdCombo.add(StatusDisplayInfo.getStatusText((int)i));
        }
        this.thresholdCombo.select(this.businessService.getObjectStatusThreshold());
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Filtering script"));
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\r\n\t$node\t\tnode being tested (null if object is not a node).\r\n\t$object\t\tobject being tested.\r\n\t$service\tcurrent business service this check belongs to.\r\n\r\nReturn value: true to bind object to this business service, false to unbind, null to make no changes.");
        this.filterSource.setText(this.businessService.getAutoBindFilter());
        this.filterSource.setEnabled(this.businessService.isAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        boolean apply = this.checkboxEnableBind.getSelection();
        boolean remove = this.checkboxEnableUnbind.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialStatusThreshold == this.thresholdCombo.getSelectionIndex() && this.initialAutoBindFilter.equals(this.filterSource.getText())) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.businessService.getObjectId());
        md.setAutoBindFilter(this.filterSource.getText());
        int flags = this.businessService.getAutoBindFlags();
        flags = apply ? flags | 1 : flags & 0xFFFFFFFE;
        flags = remove ? flags | 2 : flags & 0xFFFFFFFD;
        md.setAutoBindFlags(Integer.valueOf(flags));
        md.setObjectStatusThreshold(Integer.valueOf(this.thresholdCombo.getSelectionIndex()));
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    public String getId() {
        return "objectAutoBind";
    }

    public boolean isVisible() {
        return this.object instanceof BaseBusinessService;
    }

    public int getPriority() {
        return 25;
    }
}

