/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.businessservice.views;

import java.util.Date;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.DateTimeSelector;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.businessservice.views.BusinessServiceAvailabilityView;
import org.netxms.nxmc.modules.businessservice.views.helpers.BusinessServiceTicketComparator;
import org.netxms.nxmc.modules.businessservice.views.helpers.BusinessServiceTicketLabelProvider;
import org.netxms.nxmc.modules.charts.api.ChartColor;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.DateBuilder;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class BusinessServiceAvailabilityView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(BusinessServiceAvailabilityView.class);
    private static final String ID = "BusinessServiceAvailability";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_SERVICE_ID = 1;
    public static final int COLUMN_CHECK_ID = 2;
    public static final int COLUMN_CHECK_DESCRIPTION = 3;
    public static final int COLUMN_CREATION_TIME = 4;
    public static final int COLUMN_TERMINATION_TIME = 5;
    public static final int COLUMN_REASON = 6;
    private NXCSession session;
    private DateTimeSelector startDateSelector;
    private DateTimeSelector endDateSelector;
    private Button buttonQuery;
    private Chart chart;
    private SortableTableViewer ticketViewer;

    public BusinessServiceAvailabilityView() {
        super(i18n.tr("Availability"), ResourceManager.getImageDescriptor((String)"icons/object-views/availability_chart.png"), ID, false);
    }

    protected void createContent(Composite parent) {
        this.session = Registry.getSession();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite queryGroup = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        queryGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        queryGroup.setLayout((Layout)layout);
        Composite timeSelectorGroup = new Composite(queryGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 30;
        timeSelectorGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        timeSelectorGroup.setLayoutData((Object)gd);
        this.startDateSelector = new DateTimeSelector(timeSelectorGroup, 0);
        Label label = new Label(timeSelectorGroup, 0x1000000);
        label.setText("\u2014");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gd);
        this.endDateSelector = new DateTimeSelector(timeSelectorGroup, 0);
        Composite buttonGroup = new Composite(queryGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonGroup.setLayoutData((Object)gd);
        this.createQuickSetButton(buttonGroup, i18n.tr("Today"), new DateBuilder().setMidnight().create(), null);
        this.createQuickSetButton(buttonGroup, i18n.tr("Yesterday"), new DateBuilder().setMidnight().add(5, -1).create(), new DateBuilder().setMidnight().add(13, -1).create());
        this.createQuickSetButton(buttonGroup, i18n.tr("This month"), new DateBuilder().set(5, 1).setMidnight().create(), null);
        this.createQuickSetButton(buttonGroup, i18n.tr("Last month"), new DateBuilder().add(2, -1).set(5, 1).setMidnight().create(), new DateBuilder().add(2, -1).setLastDayOfMonth().setMidnight().add(13, -1).create());
        this.createQuickSetButton(buttonGroup, i18n.tr("This year"), new DateBuilder().set(6, 1).setMidnight().create(), null);
        this.createQuickSetButton(buttonGroup, i18n.tr("Last year"), new DateBuilder().add(1, -1).set(6, 1).setMidnight().create(), new DateBuilder().set(6, 1).setMidnight().add(13, -1).create());
        this.buttonQuery = new Button(queryGroup, 8);
        this.buttonQuery.setText(i18n.tr("Query"));
        this.buttonQuery.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalAlignment = 131072;
        this.buttonQuery.setLayoutData((Object)gd);
        Label separator = new Label(parent, 258);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gd);
        ChartConfiguration chartConfiguration = new ChartConfiguration();
        chartConfiguration.setLegendVisible(true);
        chartConfiguration.setLegendPosition(2);
        chartConfiguration.setTranslucent(false);
        this.chart = new Chart(parent, 0, ChartType.PIE, chartConfiguration);
        this.chart.setBackground(this.getDisplay().getSystemColor(22));
        this.chart.addParameter(new GraphItem(DataType.FLOAT, i18n.tr("Uptime"), i18n.tr("Uptime"), "%s"));
        this.chart.addParameter(new GraphItem(DataType.FLOAT, i18n.tr("Downtime"), i18n.tr("Downtime"), "%s"));
        this.chart.setPaletteEntry(0, new ChartColor(127, 154, 72));
        this.chart.setPaletteEntry(1, new ChartColor(158, 65, 62));
        this.chart.rebuild();
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.chart.setLayoutData((Object)gd);
        separator = new Label(parent, 258);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gd);
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Service"), i18n.tr("Check ID"), i18n.tr("Description"), i18n.tr("Created"), i18n.tr("Closed"), i18n.tr("Reason")};
        int[] widths = new int[]{70, 200, 70, 300, 150, 150, 300};
        this.ticketViewer = new SortableTableViewer(parent, names, widths, 0, 1024, -1);
        this.ticketViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ticketViewer.setLabelProvider((IBaseLabelProvider)new BusinessServiceTicketLabelProvider());
        this.ticketViewer.setComparator((ViewerComparator)new BusinessServiceTicketComparator());
        WidgetHelper.restoreColumnSettings((Table)this.ticketViewer.getTable(), (String)ID);
        this.ticketViewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.ticketViewer.getTable().setLayoutData((Object)gd);
    }

    private void createQuickSetButton(Composite parent, String name, Date startTime, Date endTime) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        button.setLayoutData((Object)gd);
    }

    protected void onObjectChange(AbstractObject object) {
        this.ticketViewer.setInput((Object)new Object[0]);
        this.chart.clearParameters();
        this.chart.refresh();
    }

    public void refresh() {
        TimePeriod timePeriod = new TimePeriod(TimeFrameType.FIXED, 0, null, this.startDateSelector.getValue(), this.endDateSelector.getValue());
        4 availabilityJob = new /* Unavailable Anonymous Inner Class!! */;
        availabilityJob.setUser(false);
        availabilityJob.start();
        5 ticketJob = new /* Unavailable Anonymous Inner Class!! */;
        ticketJob.setUser(false);
        ticketJob.start();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof BusinessService && !(context instanceof BusinessServicePrototype);
    }

    public int getPriority() {
        return 70;
    }
}

