/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.GenericComparisonChart;

public abstract class GenericGauge
extends GenericComparisonChart {
    protected static final int OUTER_MARGIN_WIDTH = 5;
    protected static final int OUTER_MARGIN_HEIGHT = 5;
    protected static final int INNER_MARGIN_WIDTH = 5;
    protected static final int INNER_MARGIN_HEIGHT = 5;
    protected static final RGB GREEN_ZONE_COLOR = new RGB(0, 224, 0);
    protected static final RGB YELLOW_ZONE_COLOR = new RGB(255, 242, 0);
    protected static final RGB RED_ZONE_COLOR = new RGB(224, 0, 0);

    public GenericGauge(Chart parent) {
        super(parent);
    }

    protected void render(GC gc) {
        block5: {
            List series;
            List items;
            ChartConfiguration config;
            int top;
            Point size;
            block4: {
                size = this.getSize();
                top = 5;
                config = this.chart.getConfiguration();
                items = this.chart.getItems();
                if (items.size() == 0 || size.x < 10 || size.y < 10) {
                    return;
                }
                series = this.chart.getDataSeries();
                if (!config.isTransposed()) break block4;
                int w = size.x - 10;
                int h = (size.y - 5 - top) / items.size();
                Point minSize = this.getMinElementSize();
                if (w < minSize.x || h < minSize.x) break block5;
                for (int i = 0; i < items.size(); ++i) {
                    this.renderElement(gc, config, (GraphItem)items.get(i), (DataSeries)series.get(i), 0, top + i * h, w, h);
                }
                break block5;
            }
            int w = (size.x - 10) / items.size();
            int h = size.y - 5 - top;
            Point minSize = this.getMinElementSize();
            if (w >= minSize.x && h >= minSize.x) {
                for (int i = 0; i < items.size(); ++i) {
                    this.renderElement(gc, config, (GraphItem)items.get(i), (DataSeries)series.get(i), i * w, top, w, h);
                }
            }
        }
    }

    protected Point getMinElementSize() {
        return new Point(10, 10);
    }

    protected abstract void renderElement(GC var1, ChartConfiguration var2, GraphItem var3, DataSeries var4, int var5, int var6, int var7, int var8);
}

