/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.IAxisTick;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.charts.api.ChartColor;
import org.netxms.nxmc.modules.charts.api.DataPoint;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.PlotArea;
import org.netxms.nxmc.modules.charts.widgets.internal.SelectionRectangle;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LineChart
extends org.eclipse.swtchart.Chart
implements PlotArea {
    private static final Logger logger = LoggerFactory.getLogger(LineChart.class);
    private static final int MAX_ZOOM_LEVEL = 16;
    private Chart chart;
    private ChartConfiguration configuration;
    private ColorCache colorCache;
    private PreferenceStore preferenceStore;
    private long timeFrom;
    private long timeTo;
    private boolean showToolTips;
    private boolean selectionActive = false;
    private int zoomLevel = 0;
    private MouseMoveListener moveListener;
    private SelectionRectangle selection = new SelectionRectangle();
    private MouseListener zoomMouseListener = null;
    private PaintListener zoomPaintListener = null;
    private boolean tooltipShown = false;
    private boolean zoomedToSelectionX = false;
    private boolean zoomedToSelectionY = false;
    private Date delayedRangeFrom;
    private Date delayedRangeTo;

    public LineChart(Chart parent) {
        super((Composite)parent, 0);
        this.chart = parent;
        this.configuration = this.chart.getConfiguration();
        this.colorCache = this.chart.getColorCache();
        this.preferenceStore = PreferenceStore.getInstance();
        this.showToolTips = this.preferenceStore.getAsBoolean("Chart.ShowToolTips", true);
        this.setBackground(parent.getBackground());
        this.selection.setColor(this.getColorFromPreferences("Chart.Colors.Selection"));
        this.getTitle().setVisible(false);
        this.getLegend().setVisible(false);
        this.setTranslucent(this.configuration.isTranslucent());
        this.timeTo = System.currentTimeMillis();
        this.timeFrom = this.timeTo - 3600000L;
        IAxisSet axisSet = this.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        xAxis.getTitle().setVisible(false);
        xAxis.setRange(new Range((double)this.timeFrom, (double)this.timeTo));
        IAxisTick xTick = xAxis.getTick();
        xTick.setForeground(this.getColorFromPreferences("Chart.Axis.X.Color"));
        DateFormat format = DateFormatFactory.getShortTimeFormat();
        xTick.setFormat((Format)format);
        IAxis yAxis = axisSet.getYAxis(0);
        yAxis.getTitle().setVisible(false);
        yAxis.getTick().setForeground(this.getColorFromPreferences("Chart.Axis.Y.Color"));
        yAxis.enableLogScale(this.configuration.isLogScale());
        if (!this.configuration.isAutoScale()) {
            yAxis.setRange(new Range(this.configuration.getMinYScaleValue(), this.configuration.getMaxYScaleValue()));
        }
        xAxis.getGrid().setStyle(this.getLineStyleFromPreferences("Chart.Grid.X.Style"));
        xAxis.getGrid().setForeground(this.getColorFromPreferences("Chart.Grid.X.Color"));
        yAxis.getGrid().setStyle(this.getLineStyleFromPreferences("Chart.Grid.Y.Style"));
        yAxis.getGrid().setForeground(this.getColorFromPreferences("Chart.Grid.Y.Color"));
        this.setGridVisible(this.configuration.isGridVisible());
        this.getPlotArea().setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        IPlotArea plotArea = this.getPlotArea();
        if (this.showToolTips) {
            WidgetHelper.attachMouseTrackListener((Composite)((Composite)plotArea.getControl()), (MouseTrackListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        plotArea.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.zoomMouseListener = new /* Unavailable Anonymous Inner Class!! */;
        this.zoomPaintListener = new /* Unavailable Anonymous Inner Class!! */;
        this.setZoomEnabled(parent.getConfiguration().isZoomEnabled());
        plotArea.addCustomPaintListener((ICustomPaintListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void startSelection(MouseEvent e) {
        if (this.zoomLevel >= 16) {
            return;
        }
    }

    private void endSelection() {
        if (!this.selectionActive) {
            return;
        }
    }

    private void setRange(Point range, IAxis axis) {
        double min = axis.getDataCoordinate(range.x);
        double max = axis.getDataCoordinate(range.y);
        axis.setRange(new Range(min, max));
    }

    private Color getColorFromPreferences(String name) {
        return this.colorCache.create(this.preferenceStore.getAsColor(name));
    }

    private LineStyle getLineStyleFromPreferences(String name) {
        String value = this.preferenceStore.getAsString(name);
        for (LineStyle s : LineStyle.values()) {
            if (!s.label.equalsIgnoreCase(value)) continue;
            return s;
        }
        return LineStyle.NONE;
    }

    private ILineSeries<?> addLineSeries(int index, String description, Date[] xSeries, double[] ySeries) {
        ISeriesSet seriesSet = this.getSeriesSet();
        ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, Integer.toString(index));
        series.setDescription(description);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setLineWidth(this.configuration.getLineWidth());
        series.setLineColor(this.getColorFromPreferences("Chart.Colors.Data." + index));
        series.setXDateSeries(xSeries);
        series.setYSeries(ySeries);
        try {
            series.enableStack(this.configuration.isStacked());
        }
        catch (IllegalStateException e) {
            logger.error("Exception while adding chart series", (Throwable)e);
        }
        return series;
    }

    public void setTimeRange(Date from, Date to) {
        int angle;
        DateFormat format;
        if (this.zoomedToSelectionX) {
            this.delayedRangeFrom = from;
            this.delayedRangeTo = to;
            return;
        }
        this.delayedRangeFrom = null;
        this.delayedRangeTo = null;
        this.timeFrom = from.getTime();
        this.timeTo = to.getTime();
        this.getAxisSet().getXAxis(0).setRange(new Range((double)this.timeFrom, (double)this.timeTo));
        int seconds = (int)((this.timeTo - this.timeFrom) / 1000L);
        if (seconds <= 600) {
            format = DateFormatFactory.getTimeFormat();
            angle = 0;
        } else if (seconds <= 86400) {
            format = DateFormatFactory.getShortTimeFormat();
            angle = 0;
        } else if (seconds <= 604800) {
            format = new SimpleDateFormat("E " + DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
            angle = 0;
        } else {
            format = DateFormat.getDateTimeInstance(3, 3);
            angle = 45;
        }
        IAxisTick xTick = this.getAxisSet().getXAxis(0).getTick();
        xTick.setFormat((Format)format);
        xTick.setTickLabelAngle(angle);
    }

    private void paintThresholds(PaintEvent e, IAxis axis) {
        GC gc = e.gc;
        Rectangle clientArea = ((Composite)this.getPlotArea().getControl()).getClientArea();
        NXCSession session = Registry.getSession();
        List items = this.chart.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Threshold[] tr = this.chart.getThreshold(i);
            if (!((GraphItem)items.get(i)).isShowThresholds() || this.configuration.isStacked() || tr == null) continue;
            for (int j = 0; j < tr.length; ++j) {
                try {
                    int y = axis.getPixelCoordinate((double)Integer.parseInt(tr[j].getValue()));
                    EventTemplate event = session.findEventTemplateByCode((long)tr[j].getFireEvent());
                    gc.setForeground(StatusDisplayInfo.getStatusColor((Severity)event.getSeverity()));
                    gc.setLineStyle(3);
                    gc.setLineWidth(3);
                    gc.drawLine(0, y, clientArea.width, y);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void refresh() {
        List items = this.chart.getItems();
        for (int i = 0; i < items.size(); ++i) {
            this.updateSeries(i, (GraphItem)items.get(i));
        }
        this.updateLayout();
        this.updateStackAndRiserData();
        if (this.configuration.isAutoScale() && !this.zoomedToSelectionY) {
            this.adjustYAxis(true);
        } else {
            this.redraw();
        }
    }

    private void updateSeries(int index, GraphItem item) {
        DciDataRow[] values = ((DataSeries)this.chart.getDataSeries().get(index)).getValues();
        Date[] xSeries = new Date[values.length];
        double[] ySeries = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            xSeries[i] = values[i].getTimestamp();
            ySeries[i] = values[i].getValueAsDouble();
        }
        ILineSeries series = this.addLineSeries(index, item.getDescription(), xSeries, ySeries);
        if (item.getColor() != -1) {
            series.setLineColor(ColorConverter.colorFromInt((int)item.getColor(), (ColorCache)this.colorCache));
        }
        series.enableArea(item.isArea(this.configuration.isArea()));
        series.setInverted(item.isInverted());
    }

    private void setZoomEnabled(boolean enableZoom) {
        IPlotArea plotArea = this.getPlotArea();
        if (enableZoom) {
            plotArea.addMouseListener(this.zoomMouseListener);
            ((Canvas)plotArea.getControl()).addPaintListener(this.zoomPaintListener);
        } else {
            plotArea.removeMouseListener(this.zoomMouseListener);
            ((Canvas)plotArea.getControl()).removePaintListener(this.zoomPaintListener);
        }
    }

    private static double adjustRange(double upper) {
        double adjustedUpper = upper;
        for (double d = 1.0E-5; d < 1.0E19; d *= 10.0) {
            if (!(upper > d) || !(upper <= d * 10.0)) continue;
            adjustedUpper -= adjustedUpper % d;
            adjustedUpper += d;
            break;
        }
        return adjustedUpper;
    }

    private void setGridVisible(boolean visible) {
        LineStyle ls = visible ? LineStyle.DOT : LineStyle.NONE;
        this.getAxisSet().getXAxis(0).getGrid().setStyle(ls);
        this.getAxisSet().getYAxis(0).getGrid().setStyle(ls);
    }

    public void adjustXAxis(boolean repaint) {
        this.zoomedToSelectionX = false;
        if (this.delayedRangeFrom != null) {
            this.setTimeRange(this.delayedRangeFrom, this.delayedRangeTo);
        } else {
            for (IAxis axis : this.getAxisSet().getXAxes()) {
                axis.adjustRange();
            }
        }
        if (repaint) {
            this.redraw();
        }
    }

    public void adjustYAxis(boolean repaint) {
        this.zoomedToSelectionY = false;
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        yAxis.adjustRange();
        Range range = yAxis.getRange();
        if (!this.configuration.isModifyYBase() && range.lower > 0.0) {
            range.lower = 0.0;
        } else if (range.lower < 0.0) {
            range.lower = -LineChart.adjustRange((double)Math.abs(range.lower));
        }
        range.upper = LineChart.adjustRange((double)range.upper);
        yAxis.setRange(range);
        if (repaint) {
            this.redraw();
        }
    }

    public void zoomIn() {
        this.getAxisSet().zoomIn();
        this.redraw();
    }

    public void zoomOut() {
        this.getAxisSet().zoomOut();
        this.redraw();
    }

    public void setAxisColor(ChartColor color) {
        Color c = this.colorCache.create(color.getRGBObject());
        this.getAxisSet().getXAxis(0).getTick().setForeground(c);
        this.getAxisSet().getYAxis(0).getTick().setForeground(c);
    }

    public void setGridColor(ChartColor color) {
        Color c = this.colorCache.create(color.getRGBObject());
        this.getAxisSet().getXAxis(0).getGrid().setForeground(c);
        this.getAxisSet().getYAxis(0).getGrid().setForeground(c);
    }

    public DataPoint getClosestDataPoint(int px, int py) {
        ISeries[] series;
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        double x = xAxis.getDataCoordinate(px);
        double y = yAxis.getDataCoordinate(py);
        double closestX = 0.0;
        double closestY = 0.0;
        double minDist = Double.MAX_VALUE;
        ISeries closestSeries = null;
        for (ISeries s : series = this.getSeriesSet().getSeries()) {
            double[] xS = s.getXSeries();
            double[] yS = s.getYSeries();
            for (int i = 0; i < xS.length; ++i) {
                double newDist = Math.sqrt(Math.pow(x - xS[i], 2.0) + Math.pow(y - yS[i], 2.0));
                if (!(newDist < minDist)) continue;
                minDist = newDist;
                closestX = xS[i];
                closestY = yS[i];
                closestSeries = s;
            }
        }
        return closestSeries != null ? new DataPoint(new Date((long)closestX), closestY, closestSeries) : null;
    }

    public ISeries<?> getSeriesAtPoint(int px, int py) {
        ISeries[] series;
        for (ISeries s : series = this.getSeriesSet().getSeries()) {
            int size = s.getSize();
            for (int i = 1; i < size; ++i) {
                Point p1 = s.getPixelCoordinates(i - 1);
                Point p2 = s.getPixelCoordinates(i);
                if (px > p1.x + 2 || px < p2.x - 2 || py < Math.min(p1.y, p2.y) - 2 || py > Math.max(p1.y, p2.y) + 2 || !(LineChart.pointToLineDistance((int)px, (int)py, (Point)p2, (Point)p1) <= (double)((ILineSeries)s).getLineWidth() * 3.0)) continue;
                return s;
            }
        }
        return null;
    }

    private static double pointToLineDistance(int x, int y, Point p1, Point p2) {
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        double area2 = Math.abs(dy * x - dx * y + p2.x * p1.y - p2.y * p1.x);
        double dist = Math.sqrt(dx * dx + dy * dy);
        return area2 / dist;
    }

    static /* synthetic */ boolean access$000(LineChart x0) {
        return x0.useMultipliers;
    }

    static /* synthetic */ double access$100(LineChart x0) {
        return x0.cachedTickStep;
    }
}

