/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.GenericComparisonChart;
import org.netxms.nxmc.tools.ColorConverter;

public class PieChart
extends GenericComparisonChart {
    private static final int MARGIN_WIDTH = 5;
    private static final int MARGIN_HEIGHT = 5;

    public PieChart(Chart parent) {
        super(parent);
    }

    protected void createFonts() {
    }

    protected void disposeFonts() {
    }

    protected void render(GC gc) {
        Point size = this.getSize();
        List items = this.chart.getItems();
        if (items.isEmpty() || size.x < 10 || size.y < 10) {
            return;
        }
        List series = this.chart.getDataSeries();
        if (series.isEmpty()) {
            return;
        }
        double total = 0.0;
        double[] values = new double[series.size()];
        for (int i = 0; i < series.size(); ++i) {
            values[i] = ((DataSeries)series.get(i)).getCurrentValue();
            total += values[i] < 0.0 ? 0.0 : values[i];
        }
        if (total == 0.0) {
            return;
        }
        double[] angularSize = new double[series.size()];
        for (int i = 0; i < values.length; ++i) {
            angularSize[i] = (values[i] < 0.0 ? 0.0 : values[i]) / total * 360.0;
        }
        if (this.chart.getConfiguration().isTranslucent()) {
            gc.setAlpha(127);
        }
        int boxSize = Math.min(size.x - 10, size.y - 10);
        int x = (size.x - boxSize) / 2;
        int y = (size.y - boxSize) / 2;
        int startAngle = 0;
        for (int i = 0; i < values.length; ++i) {
            int color = ((GraphItem)items.get(i)).getColor();
            gc.setBackground(this.chart.getColorCache().create(color == -1 ? this.chart.getPaletteEntry(i).getRGBObject() : ColorConverter.rgbFromInt((int)color)));
            int sectorSize = i == values.length - 1 ? 360 - startAngle : (int)Math.round(angularSize[i]);
            gc.fillArc(x, y, boxSize, boxSize, startAngle, sectorSize);
            startAngle += sectorSize;
        }
    }
}

