/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class EditDciSummaryTableColumnDlg
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(EditDciSummaryTableColumnDlg.class);
    private DciSummaryTableColumn column;
    private LabeledText name;
    private LabeledText dciName;
    private Button checkDescriptionMatch;
    private Button checkRegexpMatch;
    private Button checkMultivalued;
    private LabeledText separator;

    public EditDciSummaryTableColumnDlg(Shell parentShell, DciSummaryTableColumn column) {
        super(parentShell);
        this.column = column;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(i18n.tr("Name"));
        this.name.getTextControl().setTextLimit(127);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.name.setLayoutData((Object)gd);
        this.name.setText(this.column.getName());
        this.dciName = new LabeledText(dialogArea, 0);
        this.dciName.setLabel(i18n.tr("DCI name"));
        this.dciName.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dciName.setLayoutData((Object)gd);
        this.dciName.setText(this.column.getDciName());
        this.checkDescriptionMatch = new Button(dialogArea, 32);
        this.checkDescriptionMatch.setText("Match by description instead of name");
        this.checkDescriptionMatch.setSelection(this.column.isDescriptionMatch());
        this.checkRegexpMatch = new Button(dialogArea, 32);
        this.checkRegexpMatch.setText(i18n.tr("Use regular expression for name or description matching"));
        this.checkRegexpMatch.setSelection(this.column.isRegexpMatch());
        this.checkMultivalued = new Button(dialogArea, 32);
        this.checkMultivalued.setText("&Multivalued column");
        this.checkMultivalued.setSelection(this.column.isMultivalued());
        this.checkMultivalued.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.separator = new LabeledText(dialogArea, 0);
        this.separator.setLabel("&Separator for multiple values");
        this.separator.getTextControl().setTextLimit(15);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.separator.setLayoutData((Object)gd);
        this.separator.setText(this.column.getSeparator());
        this.separator.setEnabled(this.column.isMultivalued());
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Edit Column"));
    }

    protected void okPressed() {
        this.column.setName(this.name.getText());
        this.column.setDciName(this.dciName.getText());
        this.column.setDescriptionMatch(this.checkDescriptionMatch.getSelection());
        this.column.setRegexpMatch(this.checkRegexpMatch.getSelection());
        this.column.setMultivalued(this.checkMultivalued.getSelection());
        this.column.setSeparator(this.separator.getText().trim());
        super.okPressed();
    }
}

