/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciValue;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciList;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SelectNodeDciDialog
extends Dialog {
    private static I18n i18n = LocalizationHelper.getI18n(SelectNodeDciDialog.class);
    private long nodeId;
    private DciList dciList;
    private List<DciValue> selection;
    private int dcObjectType = -1;

    public SelectNodeDciDialog(Shell parentShell, long nodeId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.nodeId = nodeId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Select DCI"));
        PreferenceStore settings = PreferenceStore.getInstance();
        try {
            newShell.setSize(settings.getAsPoint("SelectDciDialog.size", 600, 400));
            newShell.setLocation(settings.getAsPoint("SelectDciDialog.location", 100, 100));
        }
        catch (NumberFormatException e) {
            newShell.setSize(400, 250);
            newShell.setLocation(100, 100);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        this.dciList = new DciList(null, dialogArea, 2048, null, "SelectNodeDciDialog.dciList", this.dcObjectType, 4, false);
        this.dciList.setDcObjectType(this.dcObjectType);
        this.dciList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dciList.setNode(Registry.getSession().findObjectById(this.nodeId));
        return dialogArea;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        Point pleace = this.getShell().getLocation();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("SelectDciDialog.location", pleace);
        settings.set("SelectDciDialog.size", size);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selection = this.dciList.getSelection();
        if (this.selection == null || this.selection.size() == 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Please select DCI fro the list and then press OK"));
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    public DciValue getSelection() {
        if (this.selection.size() > 0) {
            return (DciValue)this.selection.get(0);
        }
        return null;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        if (this.dciList != null) {
            this.dciList.setDcObjectType(dcObjectType);
        }
    }
}

