/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.InstanceDiscovery;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.tools.WidgetFactory;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class InstanceDiscovery
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(InstanceDiscovery.class);
    private static final String[] DCI_FUNCTIONS = new String[]{"FindDCIByName", "FindDCIByDescription", "GetDCIObject", "GetDCIValue", "GetDCIValueByDescription", "GetDCIValueByName"};
    private static final String[] DCI_VARIABLES = new String[]{"$dci", "$node"};
    private DataCollectionObject dco;
    private Combo discoveryMethod;
    private LabeledText discoveryData;
    private ScriptEditor filterScript;
    private Group groupRetention;
    private Combo instanceRetentionMode;
    private Spinner instanceRetentionTime;

    public InstanceDiscovery(DataCollectionObjectEditor editor) {
        super(i18n.tr("Instance Discovery"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dco = this.editor.getObject();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.discoveryMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)i18n.tr("Instance discovery method"), (Object)"WidgetHelper::default_layout_data");
        this.discoveryMethod.add(i18n.tr("None"));
        this.discoveryMethod.add(i18n.tr("Agent List"));
        this.discoveryMethod.add(i18n.tr("Agent Table"));
        this.discoveryMethod.add(i18n.tr("SNMP Walk - Values"));
        this.discoveryMethod.add(i18n.tr("SNMP Walk - OIDs"));
        this.discoveryMethod.add(i18n.tr("Script"));
        this.discoveryMethod.add(i18n.tr("Windows Performance Counters"));
        this.discoveryMethod.add(i18n.tr("Web Service"));
        this.discoveryMethod.add(i18n.tr("Internal Table"));
        this.discoveryMethod.select(this.dco.getInstanceDiscoveryMethod());
        this.discoveryMethod.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.discoveryData = new LabeledText(dialogArea, 0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel((int)this.dco.getInstanceDiscoveryMethod()));
        this.discoveryData.setText(this.dco.getInstanceDiscoveryData());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.discoveryData.setLayoutData((Object)gd);
        this.discoveryData.setEnabled(this.dco.getInstanceDiscoveryMethod() != 0);
        this.groupRetention = new Group(dialogArea, 0);
        this.groupRetention.setText("Instance retention");
        gd = new GridData();
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        this.groupRetention.setLayoutData((Object)gd);
        GridLayout retentionLayout = new GridLayout();
        retentionLayout.numColumns = 2;
        retentionLayout.horizontalSpacing = 4;
        this.groupRetention.setLayout((Layout)retentionLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.instanceRetentionMode = WidgetHelper.createLabeledCombo((Composite)this.groupRetention, (int)8, (String)"Instance retention mode", (Object)gd);
        this.instanceRetentionMode.add("Server default");
        this.instanceRetentionMode.add("Custom");
        this.instanceRetentionMode.select(this.dco.getInstanceRetentionTime() == -1 ? 0 : 1);
        this.instanceRetentionMode.setEnabled(this.dco.getInstanceDiscoveryMethod() != 0);
        this.instanceRetentionMode.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.instanceRetentionTime = WidgetHelper.createLabeledSpinner((Composite)this.groupRetention, (int)2048, (String)"Instance retention time (days)", (int)0, (int)100, (Object)new GridData());
        this.instanceRetentionTime.setSelection(this.dco.getInstanceRetentionTime());
        this.instanceRetentionTime.setEnabled(this.instanceRetentionMode.getSelectionIndex() > 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        3 factory = new /* Unavailable Anonymous Inner Class!! */;
        this.filterScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)i18n.tr("Instance discovery filter script"), (Object)gd);
        this.filterScript.addFunctions(Arrays.asList(DCI_FUNCTIONS));
        this.filterScript.addVariables(Arrays.asList(DCI_VARIABLES));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.setText(this.dco.getInstanceDiscoveryFilter());
        this.filterScript.setEnabled(this.dco.getInstanceDiscoveryMethod() != 0);
        return dialogArea;
    }

    private static String getDataLabel(int method) {
        switch (method) {
            case 0: {
                return i18n.tr("Discovery data");
            }
            case 1: {
                return i18n.tr("List name");
            }
            case 2: 
            case 8: {
                return i18n.tr("Table name");
            }
            case 3: 
            case 4: {
                return i18n.tr("Base SNMP OID");
            }
            case 5: {
                return i18n.tr("Script name");
            }
            case 7: {
                return i18n.tr("Web service request");
            }
            case 6: {
                return i18n.tr("Object name");
            }
        }
        return "";
    }

    protected boolean applyChanges(boolean isApply) {
        this.dco.setInstanceDiscoveryMethod(this.discoveryMethod.getSelectionIndex());
        this.dco.setInstanceDiscoveryData(this.discoveryData.getText());
        this.dco.setInstanceDiscoveryFilter(this.filterScript.getText());
        if (this.instanceRetentionMode.getSelectionIndex() == 0) {
            this.dco.setInstanceRetentionTime(-1);
        } else {
            this.dco.setInstanceRetentionTime(this.instanceRetentionTime.getSelection());
        }
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.discoveryMethod.select(0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel((int)0));
        this.discoveryData.setText("");
        this.discoveryData.setEnabled(false);
        this.filterScript.setText("");
        this.filterScript.setEnabled(false);
        this.instanceRetentionMode.select(0);
        this.instanceRetentionTime.setSelection(0);
    }
}

